#! /usr/bin/perl -w
#
#

use strict;
use SiLKTests;

# prefix any existing PYTHONPATH with the proper directories
check_python_bin();

# create our tempdir.  clean up unless the appropriate environment
# variable is set.
my $tmpdir = File::Temp::tempdir(CLEANUP => !$ENV{SK_TESTS_SAVEOUTPUT});
exit 77 unless -d $tmpdir;

# force Python to use the temporary directory
$ENV{TMPDIR} = $tmpdir;

# this is used to print the environment so the user can see what we
# are doing
my $env = join " ", ('top_builddir='.$SiLKTests::top_builddir,
                     'srcdir='.$SiLKTests::srcdir,
                     'top_srcdir='.$SiLKTests::top_srcdir,
                     'PYTHONPATH='.$ENV{PYTHONPATH});

# the command to run that runs rwsender and rwreceiver
my $cmd = join " ", ("$SiLKTests::PYTHON $srcdir/tests/sendrcv_tests.py",
                     ($ENV{SK_TESTS_VERBOSE} ? "--verbose" : ()),
                     #"--log-level=debug",
                     );

# show the user what is about to happen
print "$env $cmd\n";

#$cmd .= " > $tmpdir/sendrcv.log";

exec $cmd;
