#line 2 "rwgeoip2ccmap.c"

#line 4 "rwgeoip2ccmap.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define yy_create_buffer geoip2ccmap__create_buffer
#define yy_delete_buffer geoip2ccmap__delete_buffer
#define yy_flex_debug geoip2ccmap__flex_debug
#define yy_init_buffer geoip2ccmap__init_buffer
#define yy_flush_buffer geoip2ccmap__flush_buffer
#define yy_load_buffer_state geoip2ccmap__load_buffer_state
#define yy_switch_to_buffer geoip2ccmap__switch_to_buffer
#define yyin geoip2ccmap_in
#define yyleng geoip2ccmap_leng
#define yylex geoip2ccmap_lex
#define yylineno geoip2ccmap_lineno
#define yyout geoip2ccmap_out
#define yyrestart geoip2ccmap_restart
#define yytext geoip2ccmap_text
#define yywrap geoip2ccmap_wrap
#define yyalloc geoip2ccmap_alloc
#define yyrealloc geoip2ccmap_realloc
#define yyfree geoip2ccmap_free

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
typedef uint64_t flex_uint64_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE geoip2ccmap_restart(geoip2ccmap_in  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern yy_size_t geoip2ccmap_leng;

extern FILE *geoip2ccmap_in, *geoip2ccmap_out;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up geoip2ccmap_text. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up geoip2ccmap_text again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	yy_size_t yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via geoip2ccmap_restart()), so that the user can continue scanning by
	 * just pointing geoip2ccmap_in at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when geoip2ccmap_text is formed. */
static char yy_hold_char;
static yy_size_t yy_n_chars;		/* number of characters read into yy_ch_buf */
yy_size_t geoip2ccmap_leng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow geoip2ccmap_wrap()'s to do buffer switches
 * instead of setting up a fresh geoip2ccmap_in.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void geoip2ccmap_restart (FILE *input_file  );
void geoip2ccmap__switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE geoip2ccmap__create_buffer (FILE *file,int size  );
void geoip2ccmap__delete_buffer (YY_BUFFER_STATE b  );
void geoip2ccmap__flush_buffer (YY_BUFFER_STATE b  );
void geoip2ccmap_push_buffer_state (YY_BUFFER_STATE new_buffer  );
void geoip2ccmap_pop_buffer_state (void );

static void geoip2ccmap_ensure_buffer_stack (void );
static void geoip2ccmap__load_buffer_state (void );
static void geoip2ccmap__init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER geoip2ccmap__flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE geoip2ccmap__scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE geoip2ccmap__scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE geoip2ccmap__scan_bytes (yyconst char *bytes,yy_size_t len  );

void *geoip2ccmap_alloc (yy_size_t  );
void *geoip2ccmap_realloc (void *,yy_size_t  );
void geoip2ccmap_free (void *  );

#define yy_new_buffer geoip2ccmap__create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        geoip2ccmap_ensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            geoip2ccmap__create_buffer(geoip2ccmap_in,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        geoip2ccmap_ensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            geoip2ccmap__create_buffer(geoip2ccmap_in,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define geoip2ccmap_wrap(n) 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

FILE *geoip2ccmap_in = (FILE *) 0, *geoip2ccmap_out = (FILE *) 0;

typedef int yy_state_type;

extern int geoip2ccmap_lineno;

int geoip2ccmap_lineno = 1;

extern char *geoip2ccmap_text;
#define yytext_ptr geoip2ccmap_text

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up geoip2ccmap_text.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	geoip2ccmap_leng = (yy_size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 14
#define YY_END_OF_BUFFER 15
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[34] =
    {   0,
        0,    0,    0,    0,    0,    0,    7,    7,   12,   12,
       15,   11,   11,    1,    2,    3,   10,    9,    4,    7,
        8,    6,    5,   11,   13,    0,    1,    2,    3,    7,
        8,   12,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    5,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    6,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[7] =
    {   0,
        1,    2,    3,    4,    5,    1
    } ;

static yyconst flex_int16_t yy_base[39] =
    {   0,
        0,    0,    6,    0,   10,   13,   18,    0,   47,   46,
       46,   51,   23,   51,   51,    0,   51,   51,   51,   14,
       51,   51,   51,    0,   51,    0,   51,   51,    0,   11,
       51,    0,   51,   28,   33,   38,   39,   43
    } ;

static yyconst flex_int16_t yy_def[39] =
    {   0,
       33,    1,   33,    3,   34,   34,   33,    7,   35,   35,
       33,   33,   33,   33,   33,   36,   33,   33,   33,   37,
       33,   33,   33,   38,   33,   13,   33,   33,   36,   37,
       33,   38,    0,   33,   33,   33,   33,   33
    } ;

static yyconst flex_int16_t yy_nxt[58] =
    {   0,
       12,   13,   14,   13,   15,   12,   16,   16,   17,   12,
       18,   16,   17,   31,   19,   17,   31,   19,   12,   20,
       21,   20,   22,   23,   26,   27,   26,   28,   12,   12,
       12,   12,   12,   24,   24,   24,   24,   24,   29,   29,
       30,   30,   30,   32,   32,   33,   32,   32,   25,   25,
       11,   33,   33,   33,   33,   33,   33
    } ;

static yyconst flex_int16_t yy_chk[58] =
    {   0,
        1,    1,    1,    1,    1,    1,    3,    3,    3,    3,
        3,    3,    5,   30,    5,    6,   20,    6,    7,    7,
        7,    7,    7,    7,   13,   13,   13,   13,   34,   34,
       34,   34,   34,   35,   35,   35,   35,   35,   36,   36,
       37,   37,   37,   38,   38,   11,   38,   38,   10,    9,
       33,   33,   33,   33,   33,   33,   33
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int geoip2ccmap__flex_debug;
int geoip2ccmap__flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *geoip2ccmap_text;
#line 1 "rwgeoip2ccmap.l"
#line 2 "rwgeoip2ccmap.l"
/*
** Copyright (C) 2016-2018 by Carnegie Mellon University.
**
** @OPENSOURCE_LICENSE_START@
** See license information in ../../LICENSE.txt
** @OPENSOURCE_LICENSE_END@
*/

/*
 *  rwgeoip2ccmap.l
 *
 *    Create a country code prefixmap (pmap) file from textual CSV
 *    input or binary input in the GeoIP Legacy format.
 *
 *
 *    The lexer expects each line of the input to have six
 *    comma-separated values (six values and five commas), where every
 *    value is wrapped in double-quotes.  Optional whitespace may
 *    surround a value.  The values are
 *
 *    0. Starting IP address in the canonical form
 *
 *    1. Ending IP address in the canonical form
 *
 *    2. Starting IP address as an integer
 *
 *    3. Ending IP address as an integer
 *
 *    4. Two letter country code abbreviation
 *
 *    5. Country name.
 *
 *
 *  Mark Thomas
 *  March 2016
 */

#include <silk/silk.h>

RCSIDENT("$SiLK: rwgeoip2ccmap.l 2e9b8964a7da 2017-12-22 18:13:18Z mthomas $");

#include <silk/skcountry.h>
#include <silk/skipaddr.h>
#include <silk/skprefixmap.h>
#include <silk/skstream.h>
#include <silk/skvector.h>
#include <silk/utils.h>

/* use TRACEMSG_LEVEL as our tracing variable */
#define TRACEMSG(msg) TRACEMSG_TO_TRACEMSGLVL(1, msg)
#include <silk/sktracemsg.h>


/* LOCAL DEFINES AND TYPEDEFS */

/* where to write --help output */
#define USAGE_FH stdout

/* label to use for unknown ranges */
#define DEFAULT_LABEL   "--"

/* default mode (type of input) to use */
#define DEFAULT_MODE    GEOIP2CCMAP_MODE_AUTO

/* number of fields expected on each line */
#define NUM_FIELDS      6

/* type of input to expect */
enum geoip2ccmap_mode_en {
    GEOIP2CCMAP_MODE_AUTO,
    GEOIP2CCMAP_MODE_IPV4,
    GEOIP2CCMAP_MODE_IPV6,
    GEOIP2CCMAP_MODE_BINARY
};
typedef enum geoip2ccmap_mode_en geoip2ccmap_mode_t;

/* information for the current statement */
typedef struct pmap_stmt_st {
    skipaddr_t          range_start;
    skipaddr_t          range_end;
    uint32_t            value;
    uint32_t            position;
} pmap_stmt_t;


/* LOCAL VARIABLE DEFINITIONS */

/* the pmap that we create */
static skPrefixMap_t *map = NULL;

/* information for the current statement */
static pmap_stmt_t stmt;

/* which line of input we are reading */
static int linenum = 1;

/* number of errors encountered during processing */
static int error_count = 0;

/* type of input: ipv4, ipv6, binary, or determined by first IP */
static geoip2ccmap_mode_t mode = DEFAULT_MODE;

/* default country code value */
static uint32_t default_value;

/* structure to map between mode names and mode IDs */
static struct mode_name_id_map_st {
    const char         *name;
    geoip2ccmap_mode_t  id;
} mode_name_id_map[] = {
    {"auto",       GEOIP2CCMAP_MODE_AUTO},
    {"ipv6",       GEOIP2CCMAP_MODE_IPV6},
    {"ipv4",       GEOIP2CCMAP_MODE_IPV4},
    {"binary",     GEOIP2CCMAP_MODE_BINARY}
};

/* help for each mode */
static const char *mode_help[] = {
    "Automatically determine the type of input",
    "Read textual IPv6 input and create an IPv6 prefix map",
    "Read textual IPv4 input and create an IPv4 prefix map",
    "Read binary input and create an IPv4 or IPv6 prefix map"
};

/* number of entries in 'mode_name_id_map' */
static const size_t mode_name_id_map_len
    = sizeof(mode_name_id_map)/sizeof(mode_name_id_map[0]);

/* input stream for reading the prefix map text */
static sk_fileptr_t in_stream;

/* output stream for the resulting prefix map */
static skstream_t *out_stream = NULL;

/* do not write the output file; simply check syntax of the input.
 * set by --dry-run */
static int dry_run = 0;

/* do not record the command line invocation in the generated prefix
 * map file. set by --invocation-strip */
static int invocation_strip = 0;


/* OPTIONS SETUP */

typedef enum {
    OPT_INPUT_FILE,
    OPT_OUTPUT_FILE,
    OPT_MODE,
    OPT_DRY_RUN,
    OPT_INVOCATION_STRIP,
    OPT_CSV_INPUT,
    OPT_V6_CSV_INPUT,
    OPT_ENCODED_INPUT
} appOptionsEnum;

static struct option appOptions[] = {
    {"input-file",          REQUIRED_ARG, 0, OPT_INPUT_FILE},
    {"output-file",         REQUIRED_ARG, 0, OPT_OUTPUT_FILE},
    {"mode",                REQUIRED_ARG, 0, OPT_MODE},
    {"dry-run",             NO_ARG,       0, OPT_DRY_RUN},
    {"invocation-strip",    NO_ARG,       0, OPT_INVOCATION_STRIP},
    {"csv-input",           NO_ARG,       0, OPT_CSV_INPUT},
    {"v6-csv-input",        NO_ARG,       0, OPT_V6_CSV_INPUT},
    {"encoded-input",       NO_ARG,       0, OPT_ENCODED_INPUT},
    {0,0,0,0}               /* sentinel entry */
};


static const char *appHelp[] = {
    ("Read the CSV form or the binary form of the GeoIP Legacy\n"
     "\tcountry code data from this file. Read from the standard input when\n"
     "\tthe switch is not provided"),
    ("Write the binary country code prefix map to this file.\n"
     "\tWrite to the standard output when the switch is not provided"),
    ("Set the type of the input and the type country code file to\n"
     "\tcreate. By default, the type of prefix map is determined by the\n"
     "\tfirst IP address seen."),
    "Parse the input but do not write the output file",
    ("Strip invocation history from the prefix map file.\n"
     "\tDef. Record command used to create the file"),
    ("Deprecated.  Replace with --mode=ipv4.\n"
     "\tAssume the input is the CSV GeoIP Legacy country code data for IPv4"),
    ("Deprecated.  Replace with --mode=ipv6.\n"
     "\tAssume the input is the CSV GeoIP Legacy country code data for IPv6"),
    ("Deprecated.  Replace with --mode=binary.\n"
     "\tAssume the input is binary GeoIP Legacy country code data for either\n"
     "\tIPv4 or IPv6"),
    (char *)NULL
};


/* LOCAL FUNCTION PROTOTYPES */

static int appOptionsHandler(clientData cData, int opt_index, char *opt_arg);
static int parseMode(int idx, const char *str, geoip2ccmap_mode_t *new_mode);
static const char *modeToName(geoip2ccmap_mode_t m);

static int  stmtEntry(const char *string);
static void stmtCreateEntry(void);
static void stmtReset(void);

/* to keep gcc quiet  */
int
geoip2ccmap_lex(void);

SK_DIAGNOSTIC_IGNORE_PUSH("-Wwrite-strings")


/*  *****  LEX INPUT FOLLOWS  *****  */

#define YY_NO_INPUT 1
/* %option noyyget_extra noyyset_extra noyyget_leng noyyget_text */
/* %option noyyget_lineno noyyset_lineno noyyget_in noyyset_in */
/* %option noyyget_out noyyset_out noyyget_lval noyyset_lval */
/* %option noyyget_lloc noyyset_lloc noyyget_debug noyyset_debug */




#line 713 "rwgeoip2ccmap.c"

#define INITIAL 0
#define ST_ENTRY 1
#define ST_CLOSE_ENTRY 2
#define ST_NEXT_ENTRY 3
#define ST_ERROR 4

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int geoip2ccmap_lex_destroy (void );

int geoip2ccmap_get_debug (void );

void geoip2ccmap_set_debug (int debug_flag  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int geoip2ccmap_wrap (void );
#else
extern int geoip2ccmap_wrap (void );
#endif
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO fwrite( geoip2ccmap_text, geoip2ccmap_leng, 1, geoip2ccmap_out )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		yy_size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( geoip2ccmap_in )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( geoip2ccmap_in ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, geoip2ccmap_in))==0 && ferror(geoip2ccmap_in)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(geoip2ccmap_in); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int geoip2ccmap_lex (void);

#define YY_DECL int geoip2ccmap_lex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after geoip2ccmap_text and geoip2ccmap_leng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
#line 238 "rwgeoip2ccmap.l"


#line 880 "rwgeoip2ccmap.c"

	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! geoip2ccmap_in )
			geoip2ccmap_in = stdin;

		if ( ! geoip2ccmap_out )
			geoip2ccmap_out = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			geoip2ccmap_ensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				geoip2ccmap__create_buffer(geoip2ccmap_in,YY_BUF_SIZE );
		}

		geoip2ccmap__load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of geoip2ccmap_text. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 34 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 33 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 240 "rwgeoip2ccmap.l"
{ ++linenum; stmtReset(); }
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 242 "rwgeoip2ccmap.l"
{ BEGIN(ST_ENTRY); }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 244 "rwgeoip2ccmap.l"
{ if (stmtEntry(geoip2ccmap_text)) {
                                            ++error_count;
                                            BEGIN(ST_ERROR);
                                        } else {
                                            BEGIN(ST_CLOSE_ENTRY);
                                        } }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 251 "rwgeoip2ccmap.l"
{ BEGIN(ST_NEXT_ENTRY); }
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 253 "rwgeoip2ccmap.l"
{ ++stmt.position; }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 255 "rwgeoip2ccmap.l"
{ BEGIN(ST_ENTRY); }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 257 "rwgeoip2ccmap.l"
;
	YY_BREAK
case 8:
/* rule 8 can match eol */
#line 260 "rwgeoip2ccmap.l"
case YY_STATE_EOF(ST_NEXT_ENTRY):
#line 260 "rwgeoip2ccmap.l"
{ ++stmt.position;
                                        stmtCreateEntry();
                                        ++linenum;
                                        stmtReset();
                                        BEGIN(INITIAL); }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 266 "rwgeoip2ccmap.l"
{ skAppPrintErr("Empty value on line %d",
                                                      linenum);
                                        ++error_count;
                                        BEGIN(ST_ERROR);
                                      }
	YY_BREAK
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 272 "rwgeoip2ccmap.l"
{ skAppPrintErr(("Line break appears"
                                                       " in value on line %d"),
                                                      linenum);
                                        ++error_count;
                                        ++linenum;
                                        stmtReset();
                                        BEGIN(INITIAL); }
	YY_BREAK
case YY_STATE_EOF(ST_ENTRY):
case YY_STATE_EOF(ST_CLOSE_ENTRY):
#line 280 "rwgeoip2ccmap.l"
{ skAppPrintErr(("End of stream appears"
                                                       " in value on line %d"),
                                                      linenum);
                                        ++error_count;
                                        BEGIN(ST_ERROR); }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 286 "rwgeoip2ccmap.l"
{ skAppPrintErr(
                                            "Unexpected input on line %d",
                                            linenum);
                                        ++error_count;
                                        BEGIN(ST_ERROR); }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 292 "rwgeoip2ccmap.l"
;
	YY_BREAK
case 13:
/* rule 13 can match eol */
YY_RULE_SETUP
#line 293 "rwgeoip2ccmap.l"
{ ++linenum;
                                        stmtReset();
                                        BEGIN(INITIAL); }
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(ST_ERROR):
#line 297 "rwgeoip2ccmap.l"
{ return 0; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 299 "rwgeoip2ccmap.l"
ECHO;
	YY_BREAK
#line 1073 "rwgeoip2ccmap.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed geoip2ccmap_in at a new source and called
			 * geoip2ccmap_lex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = geoip2ccmap_in;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( geoip2ccmap_wrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * geoip2ccmap_text, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of geoip2ccmap_lex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			yy_size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				yy_size_t new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					geoip2ccmap_realloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			geoip2ccmap_restart(geoip2ccmap_in  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) ((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) geoip2ccmap_realloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 34 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 34 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 33);

	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			yy_size_t offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					geoip2ccmap_restart(geoip2ccmap_in );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( geoip2ccmap_wrap( ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve geoip2ccmap_text */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void geoip2ccmap_restart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        geoip2ccmap_ensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            geoip2ccmap__create_buffer(geoip2ccmap_in,YY_BUF_SIZE );
	}

	geoip2ccmap__init_buffer(YY_CURRENT_BUFFER,input_file );
	geoip2ccmap__load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void geoip2ccmap__switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		geoip2ccmap_pop_buffer_state();
	 *		geoip2ccmap_push_buffer_state(new_buffer);
     */
	geoip2ccmap_ensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	geoip2ccmap__load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (geoip2ccmap_wrap()) processing, but the only time this flag
	 * is looked at is after geoip2ccmap_wrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void geoip2ccmap__load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	geoip2ccmap_in = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE geoip2ccmap__create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) geoip2ccmap_alloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in geoip2ccmap__create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) geoip2ccmap_alloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in geoip2ccmap__create_buffer()" );

	b->yy_is_our_buffer = 1;

	geoip2ccmap__init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with geoip2ccmap__create_buffer()
 * 
 */
    void geoip2ccmap__delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		geoip2ccmap_free((void *) b->yy_ch_buf  );

	geoip2ccmap_free((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a geoip2ccmap_restart() or at EOF.
 */
    static void geoip2ccmap__init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	geoip2ccmap__flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then geoip2ccmap__init_buffer was _probably_
     * called from geoip2ccmap_restart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void geoip2ccmap__flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		geoip2ccmap__load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void geoip2ccmap_push_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	geoip2ccmap_ensure_buffer_stack();

	/* This block is copied from geoip2ccmap__switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from geoip2ccmap__switch_to_buffer. */
	geoip2ccmap__load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void geoip2ccmap_pop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	geoip2ccmap__delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		geoip2ccmap__load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void geoip2ccmap_ensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)geoip2ccmap_alloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in geoip2ccmap_ensure_buffer_stack()" );
								  
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)geoip2ccmap_realloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in geoip2ccmap_ensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE geoip2ccmap__scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) geoip2ccmap_alloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in geoip2ccmap__scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	geoip2ccmap__switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to geoip2ccmap_lex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       geoip2ccmap__scan_bytes() instead.
 */
YY_BUFFER_STATE geoip2ccmap__scan_string (yyconst char * yystr )
{
    
	return geoip2ccmap__scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to geoip2ccmap_lex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE geoip2ccmap__scan_bytes  (yyconst char * yybytes, yy_size_t  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n, i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) geoip2ccmap_alloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in geoip2ccmap__scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = geoip2ccmap__scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in geoip2ccmap__scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up geoip2ccmap_text. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		geoip2ccmap_text[geoip2ccmap_leng] = (yy_hold_char); \
		(yy_c_buf_p) = geoip2ccmap_text + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		geoip2ccmap_leng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current token.
 * 
 */

int geoip2ccmap_get_debug  (void)
{
        return geoip2ccmap__flex_debug;
}

void geoip2ccmap_set_debug (int  bdebug )
{
        geoip2ccmap__flex_debug = bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from geoip2ccmap_lex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    geoip2ccmap_in = stdin;
    geoip2ccmap_out = stdout;
#else
    geoip2ccmap_in = (FILE *) 0;
    geoip2ccmap_out = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * geoip2ccmap_lex_init()
     */
    return 0;
}

/* geoip2ccmap_lex_destroy is for both reentrant and non-reentrant scanners. */
int geoip2ccmap_lex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		geoip2ccmap__delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		geoip2ccmap_pop_buffer_state();
	}

	/* Destroy the stack itself. */
	geoip2ccmap_free((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * geoip2ccmap_lex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *geoip2ccmap_alloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *geoip2ccmap_realloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void geoip2ccmap_free (void * ptr )
{
	free( (char *) ptr );	/* see geoip2ccmap_realloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 299 "rwgeoip2ccmap.l"



SK_DIAGNOSTIC_IGNORE_POP("-Wwrite-strings")

/* FUNCTION DEFINITIONS */

/*
 *  appUsageLong();
 *
 *    Print complete usage information to USAGE_FH.  Pass this
 *    function to skOptionsSetUsageCallback(); skOptionsParse() will
 *    call this funciton and then exit the program when the --help
 *    option is given.
 */
static void
appUsageLong(
    void)
{
#define USAGE_MSG                                                             \
    ("[SWITCHES]\n"                                                           \
     "\tCreate a binary prefix map file from an input file in the MaxMind\n"  \
     "\tGeoIP Legacy format.  Both the comma separated value (CSV) and the\n" \
     "\tbinary forms of the input are supported.  The input is read from\n"   \
     "\tthe named input file or from the standard input.  The prefix map\n"   \
     "\tfile is written to the named location or to the standard output if\n" \
     "\tstdout is not connected to a terminal.\n")

    FILE *fh = USAGE_FH;
    int i;
    size_t j;

    fprintf(fh, "%s %s", skAppName(), USAGE_MSG);
    fprintf(fh, "\nSWITCHES:\n");
    skOptionsDefaultUsage(fh);
    for (i = 0; appOptions[i].name; ++i) {
        switch (appOptions[i].val) {
          case OPT_MODE:
            fprintf(fh, "--%s %s. %s\tDef. %s. Choices:\n",
                    appOptions[i].name,
                    SK_OPTION_HAS_ARG(appOptions[i]), appHelp[i],
                    modeToName(DEFAULT_MODE));
            for (j = 0; j < mode_name_id_map_len; ++j) {
                fprintf(fh, "\t%-6s - %s\n",
                        mode_name_id_map[j].name, mode_help[j]);
            }
            break;

          case OPT_INVOCATION_STRIP:
            /* include the help for --notes before
             * --invocation-strip */
            skOptionsNotesUsage(fh);
            /* FALLTHROUGH */

          default:
            fprintf(fh, "--%s %s. %s\n", appOptions[i].name,
                    SK_OPTION_HAS_ARG(appOptions[i]), appHelp[i]);
            break;
        }
    }
}


/*
 *  appTeardown()
 *
 *    Teardown all modules, close all files, and tidy up all
 *    application state.
 *
 *    This function is idempotent.
 */
static void
appTeardown(
    void)
{
    static int teardownFlag = 0;

    if (teardownFlag) {
        return;
    }
    teardownFlag = 1;

    /* close streams; destroy prefix map */
    skFileptrClose(&in_stream, NULL);
    skStreamDestroy(&out_stream);
    if (map) {
        skPrefixMapDelete(map);
    }

    skAppUnregister();
}


/*
 *  appSetup(argc, argv);
 *
 *    Perform all the setup for this application include setting up
 *    required modules, parsing options, etc.  This function should be
 *    passed the same arguments that were passed into main().
 *
 *    Returns to the caller if all setup succeeds.  If anything fails,
 *    this function will cause the application to exit with a FAILURE
 *    exit status.
 */
static void
appSetup(
    int                 argc,
    char              **argv)
{
    SILK_FEATURES_DEFINE_STRUCT(features);
    int arg_index;
    int rv;

    /* verify same number of options and help strings */
    assert((sizeof(appHelp)/sizeof(char *)) ==
           (sizeof(appOptions)/sizeof(struct option)));
    assert((sizeof(mode_help)/sizeof(mode_help[0])) == mode_name_id_map_len);

    /* register the application */
    skAppRegister(argv[0]);
    skAppVerifyFeatures(&features, NULL);
    skOptionsSetUsageCallback(&appUsageLong);
    memset(&in_stream, 0, sizeof(in_stream));

    /* initialize */
    default_value = skCountryNameToCode(DEFAULT_LABEL);

    /* register the options */
    if (skOptionsRegister(appOptions, &appOptionsHandler, NULL)
        || skOptionsNotesRegister(NULL))
    {
        skAppPrintErr("Unable to register options");
        exit(EXIT_FAILURE);
    }

    /* register the teardown handler */
    if (atexit(appTeardown) < 0) {
        skAppPrintErr("Unable to register appTeardown() with atexit()");
        appTeardown();
        exit(EXIT_FAILURE);
    }

    /* parse options */
    arg_index = skOptionsParse(argc, argv);
    if (arg_index < 0) {
        skAppUsage(); /* never returns */
    }

    /* Complain about extra args on command line */
    if (arg_index != argc) {
        skAppPrintErr("Too many or unrecognized argument specified: '%s'",
                      argv[arg_index]);
        exit(EXIT_FAILURE);
    }

    /* check for input; if none specified, use stdin */
    if (!in_stream.of_name) {
        if (FILEIsATty(stdin)) {
            skAppPrintErr("Please specify '--%s=-' to read from the terminal",
                          appOptions[OPT_INPUT_FILE].name);
            exit(EXIT_FAILURE);
        }
        in_stream.of_name = "-";
    }

    /* open input stream */
    rv = skFileptrOpen(&in_stream, SK_IO_READ);
    if (rv) {
        skAppPrintErr("Unable to open input '%s': %s",
                      in_stream.of_name, skFileptrStrerror(rv));
        exit(EXIT_FAILURE);
    }

    /* output is "stdout" if none specified.  do not bind to stdout
     * when --dry-run is active */
    if (!out_stream && !dry_run) {
        if ((rv = skStreamCreate(&out_stream, SK_IO_WRITE, SK_CONTENT_SILK))
            || (rv = skStreamBind(out_stream, "stdout")))
        {
            skStreamPrintLastErr(out_stream, rv, &skAppPrintErr);
            exit(EXIT_FAILURE);
        }
    }

    return; /* OK */
}


/*
 *  status = appOptionsHandler(cData, opt_index, opt_arg);
 *
 *    Called by skOptionsParse(), this handles a user-specified switch
 *    that the application has registered, typically by setting global
 *    variables.  Returns 1 if the switch processing failed or 0 if it
 *    succeeded.  Returning a non-zero from from the handler causes
 *    skOptionsParse() to return a negative value.
 *
 *    The clientData in 'cData' is typically ignored; 'opt_index' is
 *    the index number that was specified as the last value for each
 *    struct option in appOptions[]; 'opt_arg' is the user's argument
 *    to the switch for options that have a REQUIRED_ARG or an
 *    OPTIONAL_ARG.
 */
static int
appOptionsHandler(
    clientData   UNUSED(cData),
    int                 opt_index,
    char               *opt_arg)
{
    int rv;

    switch ((appOptionsEnum)opt_index) {
      case OPT_INPUT_FILE:
        if (in_stream.of_name) {
            skAppPrintErr("Invalid %s: Switch used multiple times",
                          appOptions[opt_index].name);
            return 1;
        }
        in_stream.of_name = opt_arg;
        break;

      case OPT_OUTPUT_FILE:
        if (out_stream) {
            skAppPrintErr("Invalid %s: Switch used multiple times",
                          appOptions[opt_index].name);
            return 1;
        }
        if ((rv = skStreamCreate(&out_stream, SK_IO_WRITE, SK_CONTENT_SILK))
            || (rv = skStreamBind(out_stream, opt_arg)))
        {
            skStreamPrintLastErr(out_stream, rv, &skAppPrintErr);
            skStreamDestroy(&out_stream);
            return 1;
        }
        break;

      case OPT_MODE:
        if (parseMode(opt_index, opt_arg, &mode)) {
            return 1;
        }
        break;

      case OPT_DRY_RUN:
        dry_run = 1;
        break;

      case OPT_INVOCATION_STRIP:
        invocation_strip = 1;
        break;

      case OPT_CSV_INPUT:
        if (parseMode(opt_index, modeToName(GEOIP2CCMAP_MODE_IPV4), &mode)) {
            return 1;
        }
        break;

      case OPT_V6_CSV_INPUT:
        if (parseMode(opt_index, modeToName(GEOIP2CCMAP_MODE_IPV6), &mode)) {
            return 1;
        }
        break;

      case OPT_ENCODED_INPUT:
        if (parseMode(opt_index, modeToName(GEOIP2CCMAP_MODE_BINARY), &mode)) {
            return 1;
        }
        break;
    }

    return 0; /* OK */
}


/*
 *  ok = parseMode(string, &new_mode);
 *
 *    Parse the value in 'string' as the name of a mode and put the
 *    mode's value in 'new_mode'.
 *
 *    Return 0 on success, or -1 if 'string' does not match a mode.
 */
static int
parseMode(
    int                 opt_index,
    const char         *string,
    geoip2ccmap_mode_t *new_mode)
{
    static int mode_seen = 0;
    const char *err;
    size_t j;

    if (mode_seen) {
        skAppPrintErr("Invalid %s: Attempting to set mode multiple times",
                      appOptions[opt_index].name);
        return -1;
    }

    for (j = 0; j < mode_name_id_map_len; ++j) {
        if (0 == strncmp(string, mode_name_id_map[j].name, strlen(string))) {
            ++mode_seen;
            *new_mode = mode_name_id_map[j].id;
        }
    }
    if (1 == mode_seen) {
        return 0;
    }
    if (mode_seen > 1) {
        err = "Name is ambiguous";
    } else {
        err = "Unrecognized name";
        mode_seen = -1;
    }
    skAppPrintErr("Invalid %s '%s': %s",
                  appOptions[opt_index].name, string, err);
    return -1;
}


/*
 *  name = modeToName(mode);
 *
 *    Return the string that presents the mode 'mode'.  Abort if
 *    'mode' is not a valid mode.
 */
static const char *
modeToName(
    geoip2ccmap_mode_t  m)
{
    size_t j;

    for (j = 0; j < mode_name_id_map_len; ++j) {
        if (m == mode_name_id_map[j].id) {
            return mode_name_id_map[j].name;
        }
    }

    skAppPrintErr("Unknown mode value %d", (int)m);
    skAbort();
}


static void
stmtReset(
    void)
{
    memset(&stmt, 0, sizeof(stmt));
    stmt.value = default_value;
}

/*
 *  status = stmtEntry(string);
 *
 *    Handle part of the current line of input.
 *
 *    Return 0 on success or -1 for failure.
 */
static int
stmtEntry(
    const char         *string)
{
    int rv;

    switch (stmt.position) {
      case 0:
        /* starting IP */
        rv = skStringParseIP(&stmt.range_start, string);
        if (rv) {
            goto PARSE_ERROR;
        }
        break;
      case 1:
        /* ending IP */
        rv = skStringParseIP(&stmt.range_end, string);
        if (rv) {
            goto PARSE_ERROR;
        }
        if (skipaddrCompare(&stmt.range_start, &stmt.range_end) > 0) {
            skAppPrintErr("Invalid range on line %d: start is greater then end",
                          linenum);
            return -1;
        }
        break;
      case 2:
      case 3:
        /* starting or ending IP as an integer */
        break;
      case 4:
        /* country code as upper case characters */
        stmt.value = (uint32_t)skCountryNameToCode(string);
        if (SK_COUNTRYCODE_INVALID == stmt.value) {
            skAppPrintErr("Invalid country code on line %d '%s'",
                          linenum, string);
            return -1;
        }
        break;
      case 5:
        /* country name */
        break;
      case NUM_FIELDS:
        /* too many fields; only print the error for the first
         * field */
        skAppPrintErr("Invalid input on line %d:"
                      " More than %d CSV values are present",
                      linenum, NUM_FIELDS);
        return -1;
        break;
      default:
        break;
    }

    return 0;

  PARSE_ERROR:
    skAppPrintErr("Invalid IP on line %d '%s': %s",
                  linenum, string, skStringParseStrerror(rv));
    return -1;
}


static void
stmtCreateEntry(
    void)
{
    static int first_entry = 1;
    skPrefixMapErr_t rv;

    if (stmt.position < NUM_FIELDS) {
        skAppPrintErr("Invalid input on line %d:"
                      " Fewer than %d CSV values are present",
                      linenum, NUM_FIELDS);
        ++error_count;
    }

    if (first_entry) {
        first_entry = 0;
        if (GEOIP2CCMAP_MODE_AUTO == mode) {
            skPrefixMapContent_t content;
            if (skipaddrIsV6(&stmt.range_start)) {
                mode = GEOIP2CCMAP_MODE_IPV6;
                content = SKPREFIXMAP_CONT_ADDR_V6;
            } else {
                mode = GEOIP2CCMAP_MODE_IPV4;
                content = SKPREFIXMAP_CONT_ADDR_V4;
            }
            skPrefixMapSetContentType(map, content);
        }
    }

#if SK_ENABLE_IPV6
    if (GEOIP2CCMAP_MODE_IPV4 == mode) {
        uint32_t ipv4;
        if (skipaddrGetAsV4(&stmt.range_start, &ipv4)
            || skipaddrGetAsV4(&stmt.range_end, &ipv4))
        {
            skAppPrintErr(("Invalid IP on line %d:"
                           " IPv6 address not allowed in %s prefix map"),
                          linenum, modeToName(mode));
            ++error_count;
            return;
        }
    }
#endif  /* SK_ENABLE_IPV6 */

    rv = skPrefixMapAddRange(map, &stmt.range_start, &stmt.range_end,
                             stmt.value);
    if (rv) {
        skAppPrintErr("Cannot add entry on line %d to prefix map: %s",
                      linenum, skPrefixMapStrerror(rv));
        ++error_count;
    }
}


/*
 *    Read the binary GeoIP Legacy format and create a prefix map.
 *
 *    Each node in input consists of 6 bytes: two 24-bit,
 *    little-endian numbers representing the left and right branches
 *    of the tree.  If the most significant 16 bits of the input value
 *    are all high, that value is a leaf and the least-significant
 *    btye is an index into the country code look-up table.
 *
 */
/* number of country codes */
#define NUM_CC          256

/* how our prefixmap code marks a leaf */
#define PMAP_LEAF_BIT   UINT32_C(0x80000000)

/* how the input marks a leaf */
#define INPUT_LEAF_MASK UINT32_C(0x00ffff00)

static void
handleBinaryInput(
    int                 argc,
    char              **argv)
{
    const char cc[NUM_CC][3] = {
        "--", "ap", "eu", "ad", "ae", "af", "ag", "ai",
        "al", "am", "cw", "ao", "aq", "ar", "as", "at",
        "au", "aw", "az", "ba", "bb", "bd", "be", "bf",
        "bg", "bh", "bi", "bj", "bm", "bn", "bo", "br",

        "bs", "bt", "bv", "bw", "by", "bz", "ca", "cc",
        "cd", "cf", "cg", "ch", "ci", "ck", "cl", "cm",
        "cn", "co", "cr", "cu", "cv", "cx", "cy", "cz",
        "de", "dj", "dk", "dm", "do", "dz", "ec", "ee",

        "eg", "eh", "er", "es", "et", "fi", "fj", "fk",
        "fm", "fo", "fr", "sx", "ga", "gb", "gd", "ge",
        "gf", "gh", "gi", "gl", "gm", "gn", "gp", "gq",
        "gr", "gs", "gt", "gu", "gw", "gy", "hk", "hm",

        "hn", "hr", "ht", "hu", "id", "ie", "il", "in",
        "io", "iq", "ir", "is", "it", "jm", "jo", "jp",
        "ke", "kg", "kh", "ki", "km", "kn", "kp", "kr",
        "kw", "ky", "kz", "la", "lb", "lc", "li", "lk",

        "lr", "ls", "lt", "lu", "lv", "ly", "ma", "mc",
        "md", "mg", "mh", "mk", "ml", "mm", "mn", "mo",
        "mp", "mq", "mr", "ms", "mt", "mu", "mv", "mw",
        "mx", "my", "mz", "na", "nc", "ne", "nf", "ng",

        "ni", "nl", "no", "np", "nr", "nu", "nz", "om",
        "pa", "pe", "pf", "pg", "ph", "pk", "pl", "pm",
        "pn", "pr", "ps", "pt", "pw", "py", "qa", "re",
        "ro", "ru", "rw", "sa", "sb", "sc", "sd", "se",

        "sg", "sh", "si", "sj", "sk", "sl", "sm", "sn",
        "so", "sr", "st", "sv", "sy", "sz", "tc", "td",
        "tf", "tg", "th", "tj", "tk", "tm", "tn", "to",
        "tl", "tr", "tt", "tv", "tw", "tz", "ua", "ug",

        "um", "us", "uy", "uz", "va", "vc", "ve", "vg",
        "vi", "vn", "vu", "wf", "ws", "ye", "yt", "rs",
        "za", "zm", "me", "zw", "a1", "a2", "o1", "ax",
        "gg", "im", "je", "bl", "mf", "bq", "ss", "o1"
    };
    uint32_t leaf_cc[NUM_CC];
    sk_file_header_t *hdr;
    sk_vector_t *vec;
    uint8_t buf[6];
    size_t i;
    size_t j;
    uint32_t count;
    ssize_t rv;
    uint32_t node[2];
    int is_ipv6;

    /* convert string country codes to leaf values */
    for (i = 0; i < NUM_CC; ++i) {
        assert(skCountryNameToCode(cc[i]) != SK_COUNTRYCODE_INVALID);
        leaf_cc[i] = PMAP_LEAF_BIT | skCountryNameToCode(cc[i]);
    }

    /* create a vector to hold the nodes */
    vec = skVectorNew(sizeof(node));
    if (NULL == vec) {
        skAppPrintOutOfMemory("vector");
        exit(EXIT_FAILURE);
    }

    /* read input and add nodes to the vector */
    while (fread(buf, sizeof(buf), 1, in_stream.of_fp)) {
        for (i = 0, j = 0; i < 2; ++i, j += 3) {
            node[i] = ((buf[j+2] << 16) | (buf[j+1] << 8) | buf[j]);
            if (node[i] >= INPUT_LEAF_MASK) {
                node[i] = leaf_cc[buf[j]];
            }
        }
        if (skVectorAppendValue(vec, &node)) {
            skAppPrintOutOfMemory("vector elements");
            exit(EXIT_FAILURE);
        }
    }

    /* finished reading the input; verify the tree */

    /* visit each node until we find a node that points to a node
     * outside the tree; set the number of nodes to the index of the
     * node that points outside the tree */
    count = skVectorGetCount(vec);
    for (i = 0; i < count; ++i) {
        skVectorGetValue(&node, vec, i);
        if (((node[0] >= count) && !(node[0] & PMAP_LEAF_BIT))
            || ((node[1] >= count) && !(node[1] & PMAP_LEAF_BIT)))
        {
            count = i;
            break;
        }
    }
    if (0 == count) {
        skAppPrintErr("No valid nodes read from input");
        exit(EXIT_FAILURE);
    }

    /* detemine whether the input is IPv4 by looking over all paths
     * and recording the maximum depth */
    is_ipv6 = 0;
    {
#define MAX_DEPTH           128
#define LEAF_VALUE(leaf)    (((leaf) & ~PMAP_LEAF_BIT) & UINT32_MAX)

#if TRACEMSG_LEVEL > 0
        const char isleaf[2] = {' ', 'L'};
#endif
        uint32_t path[MAX_DEPTH];
        uint8_t lr[MAX_DEPTH];
        uint32_t n;
        int depth;
        int max_seen;

        depth = max_seen = 0;
        lr[depth] = 0;
        path[depth] = 0;
        while (depth >= 0) {
            if (lr[depth] > 1) {
                /* done with this level */
                TRACEMSG(("%4d  %8u  %u", depth, path[depth], lr[depth]));
                --depth;
            } else {
                skVectorGetValue(&node, vec, path[depth]);
                TRACEMSG(("%4d  %8u  %u  %8u%c  %8u%c",
                          depth, path[depth], lr[depth],
                          LEAF_VALUE(node[0]), isleaf[ node[0]>>31 ],
                          LEAF_VALUE(node[1]), isleaf[ node[1]>>31 ]));
                n = node[lr[depth]];
                ++lr[depth];
                if (!(n & PMAP_LEAF_BIT)) {
                    /* add a level */
                    ++depth;
                    if (depth > max_seen) {
                        max_seen = depth;
                        if (depth >= MAX_DEPTH) {
                            skAppPrintErr(
                                "Tree is malformed; tree is too deep");
                            exit(EXIT_FAILURE);
                        }
                    }
                    /* initialize the level */
                    lr[depth] = 0;
                    path[depth] = n;
                    if (n >= count) {
                        skAppPrintErr(("Tree is malformed; value %" PRIu32
                                       " is larger than tree size %" PRIu32),
                                      n, count);
                        exit(EXIT_FAILURE);
                    }
                }
            }
        }
        TRACEMSG(("max depth is %d", max_seen));
        if (max_seen > 31) {
            is_ipv6 = 1;
        }
    }

    /* we finished with verification; prepare and write the output */
    if (dry_run) {
        return;
    }

    /* initialize the stream's header (from skprefixmap.c) */
    hdr = skStreamGetSilkHeader(out_stream);
    skHeaderSetFileFormat(hdr, FT_PREFIXMAP);
    /* Country Code file versions: IPv4 is v1; IPv6 is v5 */
    skHeaderSetRecordVersion(hdr, (is_ipv6 ? 5 : 1));
    skHeaderSetCompressionMethod(hdr, SK_COMPMETHOD_NONE);
    skHeaderSetRecordLength(hdr, 1);

    /* add invocation */
    if (!invocation_strip) {
        rv = skHeaderAddInvocation(hdr, 1, argc, argv);
        if (rv) {
            skStreamPrintLastErr(out_stream, rv, &skAppPrintErr);
            exit(EXIT_FAILURE);
        }
    }

    /* add notes */
    rv = skOptionsNotesAddToStream(out_stream);
    if (rv) {
        skStreamPrintLastErr(out_stream, rv, &skAppPrintErr);
        exit(EXIT_FAILURE);
    }
    skOptionsNotesTeardown();

    /* open the output and write the header output */
    if ((rv = skStreamOpen(out_stream))
        || (rv = skStreamWriteSilkHeader(out_stream)))
    {
        skStreamPrintLastErr(out_stream, rv, &skAppPrintErr);
        exit(EXIT_FAILURE);
    }

    /* write the number of nodes, then write each node */
    if (skStreamWrite(out_stream, &count, sizeof(count)) == -1) {
        skStreamPrintLastErr(out_stream, -1, &skAppPrintErr);
        exit(EXIT_FAILURE);
    }
    for (i = 0; i < count; ++i) {
        skVectorGetValue(&node, vec, i);
        if (skStreamWrite(out_stream, &node, sizeof(node)) == -1) {
            skStreamPrintLastErr(out_stream, -1, &skAppPrintErr);
            exit(EXIT_FAILURE);
        }
    }

    skVectorDestroy(vec);

    rv = skStreamClose(out_stream);
    if (rv) {
        skStreamPrintLastErr(out_stream, rv, &skAppPrintErr);
        exit(EXIT_FAILURE);
    }
}


int main(
    int         argc,
    char      **argv)
{
    int rv;

    appSetup(argc, argv);       /* never returns on error */

    if (GEOIP2CCMAP_MODE_AUTO == mode) {
        /* read first char to see if stream is binary */
        int c;
        c = getc(in_stream.of_fp);
        if (EOF == c) {
            if (ferror(in_stream.of_fp)) {
                skAppPrintSyserror("Unable to read from %s",
                                   in_stream.of_name);
                exit(EXIT_FAILURE);
            }
        } else {
            if (!isprint(c) && !isspace(c)) {
                mode = GEOIP2CCMAP_MODE_BINARY;
            }
            c = ungetc(c, in_stream.of_fp);
            if (EOF == c) {
                skAppPrintErr("Unable to put back character");
                exit(EXIT_FAILURE);
            }
        }
    }
    if (GEOIP2CCMAP_MODE_BINARY == mode) {
        handleBinaryInput(argc, argv);
        return 0;
    }

    /* Create the output prefix map */
    if (skPrefixMapCreate(&map) != SKPREFIXMAP_OK) {
        skAppPrintErr("Error creating prefix map");
        exit(EXIT_FAILURE);
    }

    /* set the content type to the current mode, or to IPv4 if the
     * mode is "auto"; if auto, the content type may be changed once
     * we have the first line of input */
    switch (mode) {
      case GEOIP2CCMAP_MODE_IPV6:
        skPrefixMapSetContentType(map, SKPREFIXMAP_CONT_ADDR_V6);
        break;
      case GEOIP2CCMAP_MODE_IPV4:
      case GEOIP2CCMAP_MODE_AUTO:
        skPrefixMapSetContentType(map, SKPREFIXMAP_CONT_ADDR_V4);
        break;
      case GEOIP2CCMAP_MODE_BINARY:
        skAbortBadCase(mode);
    }

    rv = skPrefixMapSetDefaultVal(map, default_value);
    if (rv) {
        skAppPrintErr("Error setting default value: %s",
                      skPrefixMapStrerror(rv));
        exit(EXIT_FAILURE);
    }

    stmtReset();

    /* Process input */
    geoip2ccmap_in = in_stream.of_fp;
    geoip2ccmap_lex();

    /* finished scanning.  clean up flex's state */
#ifdef SK_HAVE_YYLEX_DESTROY
    geoip2ccmap_lex_destroy();
#else
    geoip2ccmap__delete_buffer(YY_CURRENT_BUFFER);
#endif

    if (error_count) {
        skAppPrintErr("Encountered %d error%s during processing.%s",
                      error_count, ((error_count > 1) ? "s" : ""),
                      (dry_run ? "  Output not written." : ""));
        if (dry_run) {
            exit(EXIT_FAILURE);
        }
    }
    if (dry_run) {
        appTeardown();
        return 0;
    }

    /* add invocation */
    if (!invocation_strip) {
        rv = skHeaderAddInvocation(skStreamGetSilkHeader(out_stream), 1,
                                   argc, argv);
        if (rv) {
            skStreamPrintLastErr(out_stream, rv, &skAppPrintErr);
            exit(EXIT_FAILURE);
        }
    }

    /* add notes if given */
    rv = skOptionsNotesAddToStream(out_stream);
    if (rv) {
        skStreamPrintLastErr(out_stream, rv, &skAppPrintErr);
        exit(EXIT_FAILURE);
    }
    skOptionsNotesTeardown();

    /* write output */
    rv = skStreamOpen(out_stream);
    if (rv) {
        skStreamPrintLastErr(out_stream, rv, &skAppPrintErr);
        exit(EXIT_FAILURE);
    }

    rv = skPrefixMapWrite(map, out_stream);
    if (rv != SKPREFIXMAP_OK) {
        if (rv == SKPREFIXMAP_ERR_IO) {
            skStreamPrintLastErr(out_stream,
                                 skStreamGetLastReturnValue(out_stream),
                                 &skAppPrintErr);
        } else {
            skAppPrintErr("Error writing prefix map to '%s': %s",
                          skStreamGetPathname(out_stream),
                          skPrefixMapStrerror(rv));
        }
        exit(EXIT_FAILURE);
    }

    rv = skStreamClose(out_stream);
    if (rv) {
        skStreamPrintLastErr(out_stream, rv, &skAppPrintErr);
        exit(EXIT_FAILURE);
    }

    return 0;
}


/*
** Local Variables:
** mode:c
** indent-tabs-mode:nil
** c-basic-offset:4
** End:
*/

