#! /usr/bin/perl -w
# MD5: multiple
# TEST: ./rwsplit --basename=$temp --byte-limit=10000000 --seed=737292 --file-ratio=800 ../../tests/data.rwf && ../rwcat/rwcat --compression-method=none --byte-order=little --ipv4-output $temp*

use strict;
use SiLKTests;

my $rwsplit = check_silk_app('rwsplit');
my $rwcat = check_silk_app('rwcat');
my %file;
$file{data} = get_data_or_exit77('data');
my $temp = make_tempname('byte-10M-file');
my $cmd = "$rwsplit --basename=$temp --byte-limit=10000000 --seed=737292 --file-ratio=800 $file{data}";

# clean up when we're done
END {
    if (!$ENV{SK_TESTS_SAVEOUTPUT}) {
        # remove files
        unlink glob($temp."*");
    }
}

if (!check_exit_status($cmd)) {
    exit 1;
}

# compute MD5 of each file
while (<DATA>) {
    my ($i, $md5) = split " ";
    my $f = sprintf("%s.%08d.rwf", $temp, $i);
    $cmd = "$rwcat --compression-method=none --byte-order=little --ipv4-output $f";
    check_md5_output($md5, $cmd);
}

__DATA__
403    8d1a9e1212a5d1c8435a068fed4e759e
1309   34575751b6226f23006bc3fa5e61f920
2363   bb845458d77b9cff3d20131f23786d12
2592   717180d083e8eec430dc09c1b49064ee
3549   e209dde1d6886b53b044e8849f847f29
4127   ed2628c06ef8bb4aead6f4f1ccd1f9f3
4854   062e02be2e69dc1dce0911e985701121
5863   ee452f83605b2d34241fbe8e5f45b8ef
6787   fa69a89b89c444b08925d84224a3e3d5
7528   c93f824cb3196d513f0e5a80dece87b9
8792   a3ddb0364b9ca1649708a7330dbd69b7
9408   f35ad1dfe0ad88030cd57db10ada3687
9761   7d7ec6efe4f0b555c35af749fb4ccda2
10752  8121f58b99a3ca4c6d60dd485f38a580
