#! /usr/bin/perl -w
# MD5: multiple
# TEST: ./rwsplit --basename=$temp --packet-limit=50000 --seed=737292 --sample-ratio=20 --file-ratio=10 ../../tests/data.rwf && ../rwcat/rwcat --compression-method=none --byte-order=little --ipv4-output $temp*

use strict;
use SiLKTests;

my $rwsplit = check_silk_app('rwsplit');
my $rwcat = check_silk_app('rwcat');
my %file;
$file{data} = get_data_or_exit77('data');
my $temp = make_tempname('pkt-50k-sample-file');
my $cmd = "$rwsplit --basename=$temp --packet-limit=50000 --seed=737292 --sample-ratio=20 --file-ratio=10 $file{data}";

# clean up when we're done
END {
    if (!$ENV{SK_TESTS_SAVEOUTPUT}) {
        # remove files
        unlink glob($temp."*");
    }
}

if (!check_exit_status($cmd)) {
    exit 1;
}

# compute MD5 of each file
while (<DATA>) {
    my ($i, $md5) = split " ";
    my $f = sprintf("%s.%08d.rwf", $temp, $i);
    $cmd = "$rwcat --compression-method=none --byte-order=little --ipv4-output $f";
    check_md5_output($md5, $cmd);
}

__DATA__
9    a1542f86eca8ba9d1c04698f1daefc86
18   1810a219db2b931674ebb9019fd6c75d
22   a8459dc0139870c9db730e33b6aceabc
35   e3001126552d28e23b449ffbf9f3967d
49   e44969fdb0953e906c00c6d12c893b87
54   9d99d16a1357e4d4996afde9eef5ef42
67   8b6de71198f3b61833a6444fba7480f2
79   d9b3040b4c7878c6d6628d8bbad973b6
81   2b3398e0e751b28a03f1f43dc113f2f8
95   7e88a8c6e977cadddf0d61a819affcf6
108  680cec1a67fc748d2366523344e5dd56
113  6cc0bf277212e1aabe4838a4612b12c1
123  de844dcd4a1746855539fde5d9b2b8d6
139  3338c4893b077a1da33f2c623f573328
143  5c38b1eb79f9cd36598a6be13c3024e3
