/*
** Copyright (C) 2007-2024 by Carnegie Mellon University.
**
** @OPENSOURCE_LICENSE_START@
**
** SiLK 3.23
**
** Copyright 2024 Carnegie Mellon University.
**
** NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
** INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
** UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR
** IMPLIED, AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF
** FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS
** OBTAINED FROM USE OF THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT
** MAKE ANY WARRANTY OF ANY KIND WITH RESPECT TO FREEDOM FROM PATENT,
** TRADEMARK, OR COPYRIGHT INFRINGEMENT.
**
** Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or
** contact permission@sei.cmu.edu for full terms.
**
** [DISTRIBUTION STATEMENT A] This material has been approved for public
** release and unlimited distribution.  Please see Copyright notice for
** non-US Government use and distribution.
**
** This Software includes and/or makes use of Third-Party Software each
** subject to its own license.
**
** DM24-1064
**
** @OPENSOURCE_LICENSE_END@
*/
#ifndef _RWIPA_H
#define _RWIPA_H
#ifdef __cplusplus
extern "C" {
#endif

#include <silk/silk.h>

RCSIDENTVAR(rcsID_RWIPA_H, "$SiLK: rwipa.h 6c9dfbe0b623 2024-01-17 18:02:34Z mthomas $");

#include <silk/iptree.h>
#include <silk/skbag.h>
#include <silk/skipaddr.h>
#include <silk/skipset.h>
#include <silk/skprefixmap.h>
#include <silk/sksite.h>
#include <silk/skstream.h>
#include <silk/utils.h>

#ifdef __cplusplus
extern "C" {
#endif

SK_DIAGNOSTIC_IGNORE_PUSH("-Wundef")
SK_DIAGNOSTIC_IGNORE_PUSH("-Wwrite-strings")

#include <ipa/ipa.h>

SK_DIAGNOSTIC_IGNORE_POP("-Wwrite-strings")
SK_DIAGNOSTIC_IGNORE_POP("-Wundef")

#ifdef __cplusplus
}
#endif

char *
get_ipa_config(
    void);

#ifdef __GNUC__
/* quiet warnings about unused variables symbols_main_p,
 * symbols_find_p, and symbols_none_p in ipa/ipa.h */

__attribute__((__unused__))
static int
quiet_unused_var_warnings(
    void)
{
    return ((int)symbols_main_p->symbol_token
            + (int)symbols_find_p->symbol_token
            + (int)symbols_none_p->symbol_token);
}
#endif  /* __GNUC__ */

#ifdef __cplusplus
}
#endif
#endif /* _RWIPA_H */

/*
** Local Variables:
** mode:c
** indent-tabs-mode:nil
** c-basic-offset:4
** End:
*/
