dnl Copyright (C) 2004-2024 by Carnegie Mellon University.
dnl
dnl @OPENSOURCE_LICENSE_START@
dnl
dnl SiLK 3.23
dnl
dnl Copyright 2024 Carnegie Mellon University.
dnl
dnl NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
dnl INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
dnl UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR
dnl IMPLIED, AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF
dnl FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS
dnl OBTAINED FROM USE OF THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT
dnl MAKE ANY WARRANTY OF ANY KIND WITH RESPECT TO FREEDOM FROM PATENT,
dnl TRADEMARK, OR COPYRIGHT INFRINGEMENT.
dnl
dnl Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or
dnl contact permission@sei.cmu.edu for full terms.
dnl
dnl [DISTRIBUTION STATEMENT A] This material has been approved for public
dnl release and unlimited distribution.  Please see Copyright notice for
dnl non-US Government use and distribution.
dnl
dnl This Software includes and/or makes use of Third-Party Software each
dnl subject to its own license.
dnl
dnl DM24-1064
dnl
dnl @OPENSOURCE_LICENSE_END@

dnl RCSIDENT("$SiLK: ax_check_libz.m4 6c9dfbe0b623 2024-01-17 18:02:34Z mthomas $")

# ---------------------------------------------------------------------------
# AX_CHECK_LIBZ
#
#    Determine how to use the zlib (gzip) compression library
#
#    Substitutions: SK_ENABLE_ZLIB
#    Output defines: ENABLE_ZLIB

AC_DEFUN([AX_CHECK_LIBZ],[
    ENABLE_ZLIB=0

    AC_ARG_WITH([zlib],[AS_HELP_STRING([--with-zlib=ZLIB_DIR],
            [specify location of the zlib file compression library; find "zlib.h" in ZLIB_DIR/include/; find "libz.so" in ZLIB_DIR/lib/ [auto]])[]dnl
        ],[
            if test "x$withval" != "xyes"
            then
                zlib_dir="$withval"
                zlib_includes="$zlib_dir/include"
                zlib_libraries="$zlib_dir/lib"
            fi
    ])
    AC_ARG_WITH([zlib-includes],[AS_HELP_STRING([--with-zlib-includes=DIR],
            [find "zlib.h" in DIR/ (overrides ZLIB_DIR/include/)])[]dnl
        ],[
            if test "x$withval" = "xno"
            then
                zlib_dir=no
            elif test "x$withval" != "xyes"
            then
                zlib_includes="$withval"
            fi
    ])
    AC_ARG_WITH([zlib-libraries],[AS_HELP_STRING([--with-zlib-libraries=DIR],
            [find "libz.so" in DIR/ (overrides ZLIB_DIR/lib/)])[]dnl
        ],[
            if test "x$withval" = "xno"
            then
                zlib_dir=no
            elif test "x$withval" != "xyes"
            then
                zlib_libraries="$withval"
            fi
    ])

    if test "x$zlib_dir" != "xno"
    then
        # Cache current values
        sk_save_LDFLAGS="$LDFLAGS"
        sk_save_LIBS="$LIBS"
        sk_save_CFLAGS="$CFLAGS"
        sk_save_CPPFLAGS="$CPPFLAGS"

        if test "x$zlib_libraries" != "x"
        then
            ZLIB_LDFLAGS="-L$zlib_libraries"
            LDFLAGS="$ZLIB_LDFLAGS $sk_save_LDFLAGS"
        fi

        if test "x$zlib_includes" != "x"
        then
            ZLIB_CFLAGS="-I$zlib_includes"
            CPPFLAGS="$ZLIB_CFLAGS $sk_save_CPPFLAGS"
        fi

        AC_CHECK_LIB([z], [gzopen],
            [ENABLE_ZLIB=1 ; ZLIB_LDFLAGS="$ZLIB_LDFLAGS -lz"])

        if test "x$ENABLE_ZLIB" = "x1"
        then
            AC_CHECK_HEADER([zlib.h], , [
                AC_MSG_WARN([Found libz but not zlib.h.  Maybe you should install zlib-devel?])
                ENABLE_ZLIB=0])
        fi

        if test "x$ENABLE_ZLIB" = "x1"
        then
            # found zlib, now look for the compressBound() function
            AC_CHECK_LIB([z], [compressBound],
                AC_DEFINE([HAVE_COMPRESSBOUND], 1,
                    [Define to 1 if your zlib library provides compressBound().]))
        fi

        # Restore cached values
        LDFLAGS="$sk_save_LDFLAGS"
        LIBS="$sk_save_LIBS"
        CFLAGS="$sk_save_CFLAGS"
        CPPFLAGS="$sk_save_CPPFLAGS"
    fi

    if test "x$ENABLE_ZLIB" != "x1"
    then
        ZLIB_CFLAGS=
        ZLIB_LDFLAGS=
    fi

    AC_DEFINE_UNQUOTED([ENABLE_ZLIB], [$ENABLE_ZLIB],
        [Define to 1 build with support for zlib compression.  Define
         to 0 otherwise.  Requires the libz library and the <zlib.h>
         header file.])
    AC_SUBST([SK_ENABLE_ZLIB], [$ENABLE_ZLIB])
])# AX_CHECK_LIBZ

dnl Local Variables:
dnl mode:autoconf
dnl indent-tabs-mode:nil
dnl End:
