##  Copyright 2005-2024 Carnegie Mellon University
##  See license information in LICENSE.txt.

##  silk.spec: Generated from silk.spec.in by make.

##  @OPENSOURCE_LICENSE_START@
##
##  SiLK 3.23
##
##  Copyright 2024 Carnegie Mellon University.
##
##  NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
##  INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
##  UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR
##  IMPLIED, AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF
##  FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS
##  OBTAINED FROM USE OF THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT
##  MAKE ANY WARRANTY OF ANY KIND WITH RESPECT TO FREEDOM FROM PATENT,
##  TRADEMARK, OR COPYRIGHT INFRINGEMENT.
##
##  Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or
##  contact permission@sei.cmu.edu for full terms.
##
##  [DISTRIBUTION STATEMENT A] This material has been approved for public
##  release and unlimited distribution.  Please see Copyright notice for
##  non-US Government use and distribution.
##
##  This Software includes and/or makes use of Third-Party Software each
##  subject to its own license.
##
##  DM24-1064
##
##  @OPENSOURCE_LICENSE_END@

#   Consider changing these defaults
# 
#   Compiled-in root of SiLK repository; must have a fallback default
#
%define data_rootdir        /data

#   Controls whether the packing-logic for rwflowpack is compiled into
#   rwflowpack or is loaded as a run-time plugin.  To use a compiled
#   in value, use one of the C files in the site directory; for
#   example:
#
#   define packing_logic    site/twoway/packlogic-twoway.c
#
%define packing_logic       %{nil}

#   Controls whether SiLK binary files are compressed and optionally
#   what compression method to use.
#   Options: none (default), zlib, lzo1x, snappy
#
%define file_compression    %{nil}

#   Determines the backward compatibility for IPset files generated by
#   this release of SiLK.  Versions of SiLK older than the value
#   specified here will be unable to read IPset files generated by the
#   SiLK you are building now.
#   Options: 1.0.0 (default), 3.7.0, 3.14.0
#
%define ipset_compat        %{nil}

#   The following --with X and --without X options are supported with
#   the default shown in brackets.
#
#   Features needing no extra libraries:
#
#   ipv6 [with]: enables working with IPv6 flow records and IPsets
#   localtime [without]: whether SiLK tools use localtime by default
#                        instead of using UTC as the default
#
#   Features requiring extra libraries:
#
#   gnutls [with]: enables TLS between rwsender and rwreceiver
#   libfixbuf [with]: enables collection of IPFIX and NetFlow v9
#   libmaxminddb [without]: enables CountryCode lookups using the
#                           MaxMind GeoIP library and data files
#   pysilk [without]: builds the silk Python module and enables using
#                     Python plugins from within the rw-tools
#   snappy [without]: builds with the snappy compression library
#

# Set build conditions for commonly selected options
%bcond ipv6         1
%bcond localtime    0
%bcond gnutls       1
%bcond libfixbuf    1
%bcond libmaxminddb 0
%bcond pysilk       0
%bcond snappy       0

%define name    silk
%define version 3.23.1
%define release 1%{!?with_ipv6:_ipv4}%{?with_localtime:_localtime}%{?with_pysilk:_pysilk}%{?with_libmaxminddb:_maxind}%{?with_snappy:_snappy}%{!?with_libfixbuf:_noIPFIX}%{!?with_gnutls:_noTLS}%{?dist}

Name:           %{name}
Version:        %{version}
Release:        %{release}
Summary:        SiLK: A network flow collection and analysis package
License:        GPLv2
Vendor:         CERT Network Situational Awareness <netsa-help@cert.org>
URL:            https://tools.netsa.cert.org/silk/
Source:         https://tools.netsa.cert.org/releases/%{name}-%{version}.tar.gz
Group:          Applications/System
Requires:       libpcap, lzo, zlib, python3
Requires(post): /sbin/ldconfig
Requires(postun): /sbin/ldconfig
Requires(preun): /sbin/chkconfig
Requires:       filesystem
BuildRequires:  systemd-rpm-macros
BuildRequires:  gcc, lzo-devel, %{_includedir}/pcap.h, zlib-devel
BuildRequires:  openssl-devel, python3-devel
%if %{with gnutls}
Requires:       gnutls >= 2.12.0
BuildRequires:  gnutls-devel >= 2.12.0
%endif
%if %{with libfixbuf}
Requires:       libfixbuf >= 1.7.0
BuildRequires:  libfixbuf-devel >= 1.7.0
%endif
%if %{with libmaxminddb}
Requires:       libmaxminddb >= 1.7.0
BuildRequires:  libmaxminddb-devel >= 1.2.0
%endif
%if %{with snappy}
Requires:       snappy
BuildRequires:  snappy-devel
%endif
BuildRoot:      %(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)

# To apply a patch to the SiLK sources: (1)put the patch file into the
# SOURCES directory, (2)uncomment the 'Patch0:' line below, (3)add the
# name of the patch file after the 'Patch0:', (4)uncomment the
# '%patch0' line in the 'prep' section below.
#
# To apply a second patch, repeat the process using 'Patch1:' and
# '%patch1' in place of 'Patch0:' and '%patch0'.
#
#Patch0:
#Patch1:
#Patch2:
#Patch3:
#Patch4:

# Path to a Python interpreter. An error is generated if this ends
# with "python" and not a more specific version (python3, python2,
# python3.9, etc).
%define __python /usr/bin/python3

# Whether to build with Python support, and paths if so
%if %{with pysilk}
%define py_sitepkg      %{python_sitelib}
%define py_sitepkg_silk %{python_sitelib}/silk
%endif

# Undefine any empty values
%if "x" == "x%{?packing_logic}"
%undefine packing_logic
%endif
%if "x" == "x%{?ipset_compat}"
%undefine ipset_compat
%endif
%if "x" == "x%{?file_compression}"
%undefine file_compression
%endif

# This file contains the list of files that comprise the silk-analysis
# RPM.  It is created during the 'install' phase.
%define sk_analysis_file   analysis-list.txt
%define sk_analysis_path   $RPM_BUILD_DIR/%{name}-%{version}/%{sk_analysis_file}

%if 0%{!?packing_logic:1}
# This file contains the names of the packing-logic plug-in files for
# the silk-rwflopack RPM.  It is created during 'install'.
%define sk_rwflowpack_file rwflowpack-list.txt
%define sk_rwflowpack_path $RPM_BUILD_DIR/%{name}-%{version}/%{sk_rwflowpack_file}
%endif


#######################################################################
# RCSIDENT("$SiLK: silk.spec.in 8dcd6216b140 2024-08-26 15:28:00Z mthomas $")
#######################################################################

%description
SiLK, the System for Internet-Level Knowledge, is a collection of
traffic analysis tools developed by the CERT Network Situational
Awareness Team (CERT NetSA) to facilitate security analysis of large
networks. The SiLK tool suite supports the efficient collection,
storage and analysis of network flow data, enabling network security
analysts to rapidly query large historical traffic data sets. SiLK is
ideally suited for analyzing traffic on the backbone or border of a
large, distributed enterprise or mid-sized ISP.

SiLK consists of two sets of tools: a packing system and analysis
suite. The packing system receives network flow information from
Netflow v5 or any IPFIX-based flowmeter and converts them into a more
space efficient format, recording the packed records into
service-specific, binary flat files. The analysis suite consists of
tools which can read these flat files and then perform various query
operations, ranging from per-record filtering to statistical analysis
of groups of records. The analysis tools interoperate using pipes,
allowing a user to develop a relatively sophisticated query from a
simple beginning.

%prep
echo Building %{name}-%{version}-%{release}
%setup -q
#
# To apply patches, see description near 'Patch0:' above.
#
#%patch0 -p1
#%patch1 -p1
#%patch2 -p1
#%patch3 -p1
#%patch4 -p1

%build
case "%{__python}" in #(
  *python)
    echo "ERROR: Ambiguous python: please use python3 (or python2) explicity in %%define python" 1>&1
    exit 1
    ;;
esac
%configure \
	--enable-data-rootdir=%{data_rootdir} \
	%{?packing_logic:--enable-packing-logic=%{packing_logic}}  \
	%{?file_compression:--enable-output-compression=%{file_compression}} \
	%{?ipset_compat:--enable-ipset-compatibility=%{ipset_compat}} \
	--enable-assert=no \
	--enable-ipv6=%{?with_ipv6:yes}%{!?with_ipv6:no} \
	--enable-localtime=%{?with_localtime:yes}%{!?with_localtime:no} \
	--with-lzo \
	--with-pcap \
	--with-zlib \
	--without-adns \
	--without-c-ares \
	--without-libipa \
	--with-gnutls=%{?with_gnutls:yes}%{!?with_gnutls:no} \
	--with-libfixbuf=%{?with_libfixbuf:yes}%{!?with_libfixbuf:no} \
	--with-libmaxminddb=%{?with_libmaxminddb:yes}%{!?with_libmaxminddb:no} \
	--with-snappy=%{?with_snappy:yes}%{!?with_snappy:no} \
	--with-python=%{?with_pysilk:yes}%{!?with_pysilk:no} \
        %{?with_pysilk:--with-python-site-dir=%{python_sitelib}} \
	--disable-static \
	PYTHON="%{__python}"
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
%{__make}

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT
%{make_install}
mkdir -p $RPM_BUILD_ROOT/%{_sysconfdir}/sysconfig
mv $RPM_BUILD_ROOT/%{_datadir}/silk/etc/*.conf $RPM_BUILD_ROOT/%{_sysconfdir}/sysconfig

mkdir -p $RPM_BUILD_ROOT%{_unitdir}
mkdir -p $RPM_BUILD_ROOT%{_sbindir}
mkdir -p $RPM_BUILD_ROOT%{_libexecdir}/silk
install --mode=0644 src/flowcap/flowcap.service $RPM_BUILD_ROOT%{_unitdir}
install --mode=0644 src/rwflowpack/rwflowappend.service $RPM_BUILD_ROOT%{_unitdir}
install --mode=0644 src/rwflowpack/rwflowpack.service $RPM_BUILD_ROOT%{_unitdir}
install --mode=0644 src/rwpollexec/rwpollexec.service $RPM_BUILD_ROOT%{_unitdir}
install --mode=0644 src/sendrcv/rwreceiver.service $RPM_BUILD_ROOT%{_unitdir}
install --mode=0644 src/sendrcv/rwsender.service $RPM_BUILD_ROOT%{_unitdir}
install --mode=0755 src/flowcap/flowcap_startup $RPM_BUILD_ROOT%{_libexecdir}/silk
install --mode=0755 src/rwflowpack/rwflowappend_startup $RPM_BUILD_ROOT%{_libexecdir}/silk
install --mode=0755 src/rwflowpack/rwflowpack_startup $RPM_BUILD_ROOT%{_libexecdir}/silk
install --mode=0755 src/rwpollexec/rwpollexec_startup $RPM_BUILD_ROOT%{_libexecdir}/silk
install --mode=0755 src/sendrcv/rwreceiver_startup $RPM_BUILD_ROOT%{_libexecdir}/silk
install --mode=0755 src/sendrcv/rwsender_startup $RPM_BUILD_ROOT%{_libexecdir}/silk

#rmdir $RPM_BUILD_ROOT/%{_datadir}/silk/etc/init.d
#rmdir $RPM_BUILD_ROOT/%{_datadir}/silk/etc
rm -f $RPM_BUILD_ROOT/%{_libdir}/silk/*.la
rm -f $RPM_BUILD_ROOT/%{_libdir}/*.la
mkdir -p $RPM_BUILD_ROOT/%{_localstatedir}/silk

# build the file list to use for the silk-analysis RPM
rm -f %{sk_analysis_path}
touch %{sk_analysis_path}
echo '%defattr(-,root,root)' >> %{sk_analysis_path}
echo '%{_datadir}/silk/addrtype-templ.txt' >> %{sk_analysis_path}

find $RPM_BUILD_ROOT/%{_bindir} -type f -print | \
    grep -v rwfileinfo | \
    grep -v rwsiteinfo | \
    grep -v silk_config | \
    sed "s!$RPM_BUILD_ROOT/*!/!" >> %{sk_analysis_path}
find $RPM_BUILD_ROOT/%{_mandir}/man1 -type f -print | \
    grep -v rwfileinfo | \
    grep -v rwsiteinfo | \
    grep -v silk_config | \
    sed "s!$RPM_BUILD_ROOT/*!/!" | \
    sed 's/$/*/' >> %{sk_analysis_path}
find $RPM_BUILD_ROOT/%{_mandir}/man3 -type f -print | \
    grep -v silk-plugin | \
    sed "s!$RPM_BUILD_ROOT/*!/!" | \
    sed 's/$/*/' >> %{sk_analysis_path}
find $RPM_BUILD_ROOT/%{_libdir}/silk -name '*.so' -type f -print | \
    grep -v packlogic | \
    sed "s!$RPM_BUILD_ROOT/*!/!" >> %{sk_analysis_path}

%if %{with pysilk}
rm -f $RPM_BUILD_ROOT/%{py_sitepkg_silk}/*.a
rm -f $RPM_BUILD_ROOT/%{py_sitepkg_silk}/*.la
# netsa_silk is packaged by netsa python
rm -f $RPM_BUILD_ROOT/%{py_sitepkg}/*.py*
rm -f $RPM_BUILD_ROOT/%{py_sitepkg}/__pycache__/*.py*
rmdir $RPM_BUILD_ROOT/%{py_sitepkg}/__pycache__ || true
echo '%dir '%{py_sitepkg_silk} >> %{sk_analysis_path}
echo %{py_sitepkg_silk}'/*' >> %{sk_analysis_path}
%endif


# if static packing-logic is not used, create the file holding the
# list of plug-in files to include with the silk-rwflowpack RPM
%if 0%{?sk_rwflowpack_path:1}
rm -f %{sk_rwflowpack_path}
touch %{sk_rwflowpack_path}
find $RPM_BUILD_ROOT/%{_libdir}/silk -name 'packlogic*.so' -type f -print | \
    sed "s!$RPM_BUILD_ROOT/*!/!" >> %{sk_rwflowpack_path}
%endif

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT


#  ###################################################################
#  silk-common

%package common
Group: Applications/System
Summary: SiLK Toolset: Common Libraries and Configuration Files
Requires: filesystem
Requires(post): /sbin/ldconfig
Requires(postun): /sbin/ldconfig
%if %{with pysilk}
Provides: netsa_silk_impl
%endif

%description common
SiLK, the System for Internet-Level Knowledge, is a collection of
traffic analysis tools developed by the CERT Network Situational
Awareness Team (CERT NetSA) to facilitate security analysis of large
networks. The SiLK tool suite supports the efficient collection,
storage and analysis of network flow data, enabling network security
analysts to rapidly query large historical traffic data sets. SiLK is
ideally suited for analyzing traffic on the backbone or border of a
large, distributed enterprise or mid-sized ISP.

The silk-common package contains the libraries and configuration files
required by the other parts of SiLK Toolset, as well as generally
useful utilities.

%files common
%defattr(-,root,root)
%{_bindir}/rwfileinfo
%{_mandir}/man1/rwfileinfo.1*
%{_bindir}/rwsiteinfo
%{_mandir}/man1/rwsiteinfo.1*
%{_libdir}/*.so.*
%dir %{_libdir}/silk
%{_mandir}/man5/*
%{_mandir}/man7/*
%dir %{_datadir}/silk
%{_datadir}/silk/*-silk.conf
%{_datadir}/silk/silk.magic

%post common
/sbin/ldconfig

%postun common
/sbin/ldconfig


#  ###################################################################
#  silk-analysis

%package analysis
Group: Applications/System
Summary: SiLK Toolset: The Analysis Suite
Requires: %{name}-common = %{version}-%{release}

%description analysis
SiLK, the System for Internet-Level Knowledge, is a collection of
traffic analysis tools developed by the CERT Network Situational
Awareness Team (CERT NetSA) to facilitate security analysis of large
networks. The SiLK tool suite supports the efficient collection,
storage and analysis of network flow data, enabling network security
analysts to rapidly query large historical traffic data sets. SiLK is
ideally suited for analyzing traffic on the backbone or border of a
large, distributed enterprise or mid-sized ISP.

The silk-analysis package contains the analysis tools that query the
SiLK Flow data collected by rwflowpack (contained in the
silk-rwflowpack package) and summarize that data in various ways.

# The file list gets generated at install time.  This list contains
# almost everything except:
# -- packlogic-*.so files used by rwflowpack (silk-rwflowpack RPM)
# -- rwfileinfo (silk-common RPM)
# -- rwsiteinfo (silk-common RPM)
# -- silk_config (silk-devel RPM)
%files analysis -f %{sk_analysis_file}


#  ###################################################################
#  silk-rwflowpack

%package rwflowpack
Group: Applications/System
Summary: SiLK Toolset: The Packer
Requires: %{name}-common = %{version}-%{release}

%description rwflowpack
SiLK, the System for Internet-Level Knowledge, is a collection of
traffic analysis tools developed by the CERT Network Situational
Awareness Team (CERT NetSA) to facilitate security analysis of large
networks. The SiLK tool suite supports the efficient collection,
storage and analysis of network flow data, enabling network security
analysts to rapidly query large historical traffic data sets. SiLK is
ideally suited for analyzing traffic on the backbone or border of a
large, distributed enterprise or mid-sized ISP.

The silk-rwflowpack package converts NetFlow v5 or IPFIX (Internet
Protocol Flow Information eXport) data to the SiLK Flow record format,
categorizes each flow (e.g., as incoming or outgoing), and stores the
data in binary flat files within a directory tree, with one file per
hour-category-sensor tuple.  Use the tools from the silk-analysis
package to query this data.  rwflowpack may capture the data itself,
or it may process files that have been created by flowcap (see the
silk-flowcap package).

# if a packing logic file is compiled into rwflowpack, then
# sk_rwflowpack_file is empty; otherwise it gives the names of plug-in
# files to package with rwflowpack
%files rwflowpack %{?sk_rwflowpack_file: -f %{sk_rwflowpack_file}}
%defattr(-,root,root)
%{_sbindir}/rwflowpack
%{_sbindir}/rwguess
%{_sbindir}/rwpackchecker
%{_mandir}/man8/rwflowpack.8*
%{_mandir}/man8/rwguess.8*
%{_mandir}/man8/rwpackchecker.8*
%config(noreplace) %{_sysconfdir}/sysconfig/rwflowpack.conf
%attr(750,root,root) %dir %{_localstatedir}/silk
%{_unitdir}/rwflowpack.service
%{_libexecdir}/silk/rwflowpack_startup

%post rwflowpack
%systemd_post rwflowpack.service

%postun rwflowpack
%systemd_postun_with_restart rwflowpack.service

%preun rwflowpack
if test -e "/sbin/chkconfig" && chkconfig --list rwflowpack 2>/dev/null; then
    /sbin/chkconfig --del rwflowpack
fi
%systemd_preun rwflowpack.service


#  ###################################################################
#  silk-flowcap

%package flowcap
Group: Applications/System
Summary: SiLK Toolset: Remote Flow Collection
Requires: %{name}-common = %{version}-%{release}

%description flowcap
SiLK, the System for Internet-Level Knowledge, is a collection of
traffic analysis tools developed by the CERT Network Situational
Awareness Team (CERT NetSA) to facilitate security analysis of large
networks. The SiLK tool suite supports the efficient collection,
storage and analysis of network flow data, enabling network security
analysts to rapidly query large historical traffic data sets. SiLK is
ideally suited for analyzing traffic on the backbone or border of a
large, distributed enterprise or mid-sized ISP.

The silk-flowcap package contains flowcap, a daemon to capture NetFlow
v5 or IPFIX flows (Internet Protocol Flow Information eXport), to
store the data temporarily in files on its local disk, and to forward
these files over the network to a machine where rwflowpack processes
the data.  flowcap is typically used with an rwsender-rwreceiver pair
to move the files across the network.

%files flowcap
%defattr(-,root,root)
%{_sbindir}/flowcap
%{_mandir}/man8/flowcap.8*
%config(noreplace) %{_sysconfdir}/sysconfig/flowcap.conf
%attr(750,root,root) %dir %{_localstatedir}/silk
%{_unitdir}/flowcap.service
%{_libexecdir}/silk/flowcap_startup

%post flowcap
%systemd_post flowcap.service

%postun flowcap
%systemd_postun_with_restart flowcap.service

%preun flowcap
if test -e "/sbin/chkconfig" && chkconfig --list flowcap 2>/dev/null; then
    /sbin/chkconfig --del flowcap
fi
%systemd_preun flowcap.service


#  ###################################################################
#  silk-rwflowappend

%package rwflowappend
Group: Applications/System
Summary: SiLK Toolset: Remote Data Storage Appending Daemon
Requires: %{name}-common = %{version}-%{release}

%description rwflowappend
SiLK, the System for Internet-Level Knowledge, is a collection of
traffic analysis tools developed by the CERT Network Situational
Awareness Team (CERT NetSA) to facilitate security analysis of large
networks. The SiLK tool suite supports the efficient collection,
storage and analysis of network flow data, enabling network security
analysts to rapidly query large historical traffic data sets. SiLK is
ideally suited for analyzing traffic on the backbone or border of a
large, distributed enterprise or mid-sized ISP.

The silk-rwflowappend package is used when the final storage location
of SiLK data files is on a different machine than that where the files
are created by the rwflowpack daemon (see the silk-rwflowpack
package).  rwflowappend watches a directory for SiLK data files and
appends those files to the final storage location where the SiLK
analysis tools (from the silk-analysis package) can process them.  To
move the files from rwflowpack to rwflowappend, an rwsender-rwreceiver
pair is typically used.

%files rwflowappend
%defattr(-,root,root)
%{_sbindir}/rwflowappend
%{_mandir}/man8/rwflowappend.8*
%config(noreplace) %{_sysconfdir}/sysconfig/rwflowappend.conf
%attr(750,root,root) %dir %{_localstatedir}/silk
%{_unitdir}/rwflowappend.service
%{_libexecdir}/silk/rwflowappend_startup

%post rwflowappend
%systemd_post rwflowappend.service

%postun rwflowappend
%systemd_postun_with_restart rwflowappend.service

%preun rwflowappend
if test -e "/sbin/chkconfig" && chkconfig --list rwflowappend 2>/dev/null; then
    /sbin/chkconfig --del rwflowappend
fi
%systemd_preun rwflowappend.service


#  ###################################################################
#  silk-rwreceiver

%package rwreceiver
Group: Applications/System
Summary: SiLK Toolset: File Transfer Receiver
Requires: %{name}-common = %{version}-%{release}

%description rwreceiver
SiLK, the System for Internet-Level Knowledge, is a collection of
traffic analysis tools developed by the CERT Network Situational
Awareness Team (CERT NetSA) to facilitate security analysis of large
networks. The SiLK tool suite supports the efficient collection,
storage and analysis of network flow data, enabling network security
analysts to rapidly query large historical traffic data sets. SiLK is
ideally suited for analyzing traffic on the backbone or border of a
large, distributed enterprise or mid-sized ISP.

The silk-rwreceiver package contains a program (rwreceiver) which
receives files over the network from one or more rwsender programs.
rwsender-rwreceiver pairs are used to move files from a machine
running flowcap and one running rwflowpack, or from the rwflowpack
machine to machine(s) running rwflowappend.

%files rwreceiver
%defattr(-,root,root)
%{_sbindir}/rwreceiver
%{_mandir}/man8/rwreceiver.8*
%config(noreplace) %{_sysconfdir}/sysconfig/rwreceiver.conf
%attr(750,root,root) %dir %{_localstatedir}/silk
%{_unitdir}/rwreceiver.service
%{_libexecdir}/silk/rwreceiver_startup

%post rwreceiver
%systemd_post rwreceiver.service

%postun rwreceiver
%systemd_postun_with_restart rwreceiver.service


%preun rwreceiver
if test -e "/sbin/chkconfig" && chkconfig --list rwreceiver 2>/dev/null; then
    /sbin/chkconfig --del rwreceiver
fi
%systemd_preun rwreceiver.service


#  ###################################################################
#  silk-rwsender

%package rwsender
Group: Applications/System
Summary: SiLK Toolset: File Transfer Sender
Requires: %{name}-common = %{version}-%{release}

%description rwsender
SiLK, the System for Internet-Level Knowledge, is a collection of
traffic analysis tools developed by the CERT Network Situational
Awareness Team (CERT NetSA) to facilitate security analysis of large
networks. The SiLK tool suite supports the efficient collection,
storage and analysis of network flow data, enabling network security
analysts to rapidly query large historical traffic data sets. SiLK is
ideally suited for analyzing traffic on the backbone or border of a
large, distributed enterprise or mid-sized ISP.

The silk-rwsender package contains a program (rwsender) which
transmits files over the network to one or more rwreceiver programs.
rwsender-rwreceiver pairs are used to move files from a machine
running flowcap and one running rwflowpack, or from the rwflowpack
machine to machine(s) running rwflowappend.

%files rwsender
%defattr(-,root,root)
%{_sbindir}/rwsender
%{_mandir}/man8/rwsender.8*
%config(noreplace) %{_sysconfdir}/sysconfig/rwsender.conf
%attr(750,root,root) %dir %{_localstatedir}/silk
%{_unitdir}/rwsender.service
%{_libexecdir}/silk/rwsender_startup

%post rwsender
%systemd_post rwsender.service

%postun rwsender
%systemd_postun_with_restart rwsender.service

%preun rwsender
if test -e "/sbin/chkconfig" && chkconfig --list rwsender 2>/dev/null; then
    /sbin/chkconfig --del rwsender
fi
%systemd_preun rwsender.service


#  ###################################################################
#  silk-rwpollexec

%package rwpollexec
Group: Applications/System
Summary: SiLK Toolset: Batch Command Executor
Requires: %{name}-common = %{version}-%{release}

%description rwpollexec
SiLK, the System for Internet-Level Knowledge, is a collection of
traffic analysis tools developed by the CERT Network Situational
Awareness Team (CERT NetSA) to facilitate security analysis of large
networks. The SiLK tool suite supports the efficient collection,
storage and analysis of network flow data, enabling network security
analysts to rapidly query large historical traffic data sets. SiLK is
ideally suited for analyzing traffic on the backbone or border of a
large, distributed enterprise or mid-sized ISP.

The silk-rwpollexec package contains a program (rwpollexec) which
monitors a directory for incoming files.  For each file, rwpollexec
executes a user-specified command.  If the command completes
successfully, the file is either moved to an archive directory or
deleted.

%files rwpollexec
%defattr(-,root,root)
%{_sbindir}/rwpollexec
%{_mandir}/man8/rwpollexec.8*
%config(noreplace) %{_sysconfdir}/sysconfig/rwpollexec.conf
%attr(750,root,root) %dir %{_localstatedir}/silk
%{_unitdir}/rwpollexec.service
%{_libexecdir}/silk/rwpollexec_startup

%post rwpollexec
%systemd_post rwpollexec.service

%postun rwpollexec
%systemd_postun_with_restart rwpollexec.service

%preun rwpollexec
if test -e "/sbin/chkconfig" && chkconfig --list rwpollexec 2>/dev/null; then
    /sbin/chkconfig --del rwpollexec
fi
%systemd_preun rwpollexec.service


#  ###################################################################
#  silk-devel

%package devel
Group: Development/Libraries
Summary: The SiLK Toolset development files

%description devel
SiLK, the System for Internet-Level Knowledge, is a collection of
traffic analysis tools developed by the CERT Network Situational
Awareness Team (CERT NetSA) to facilitate security analysis of large
networks. The SiLK tool suite supports the efficient collection,
storage and analysis of network flow data, enabling network security
analysts to rapidly query large historical traffic data sets. SiLK is
ideally suited for analyzing traffic on the backbone or border of a
large, distributed enterprise or mid-sized ISP.

The silk-devel package contains the development libraries and headers
for SiLK.  This package is required to build additional applications
or to build shared libraries for use as plug-ins to the SiLK analysis
tools.

%files devel
%defattr(-,root,root)
%{_includedir}
%{_libdir}/*.so
%{_bindir}/silk_config
%{_mandir}/man1/silk_config.1*
%{_mandir}/man3/silk-plugin.3*
