# RCSIDENT("$SiLK: build.mk 6ae403479924 2013-01-31 19:39:27Z mthomas $")

# Local rules

clean-local: clean-remove-man clean-remove-tests-touch-dir


# Rules to build (and clean) the manual pages (troff) from the Perl
# POD (Plain Old Documentation) source files
#
POD2MAN_ARGS = --center="SiLK Tool Suite" --release="$(PACKAGE_STRING)"

pod_edit = sed \
	-e 's|@SILK_DATA_ROOTDIR[@]|$(SILK_DATA_ROOTDIR)|g' \
	-e 's|@prefix[@]|$(prefix)|g'

.pod.man:
	$(POD2MAN) $(POD2MAN_ARGS) $< > $@
.pod.1:
	$(pod_edit) $< | $(POD2MAN) --section=1 --name="$*" $(POD2MAN_ARGS) > "$@"
.pod.2:
	$(pod_edit) $< | $(POD2MAN) --section=2 --name="$*" $(POD2MAN_ARGS) > "$@"
.pod.3:
	$(pod_edit) $< | $(POD2MAN) --section=3 --name="$*" $(POD2MAN_ARGS) > "$@"
.pod.5:
	$(pod_edit) $< | $(POD2MAN) --section=5 --name="$*" $(POD2MAN_ARGS) > "$@"
.pod.7:
	$(pod_edit) $< | $(POD2MAN) --section=7 --name="$*" $(POD2MAN_ARGS) > "$@"
.pod.8:
	$(pod_edit) $< | $(POD2MAN) --section=8 --name="$*" $(POD2MAN_ARGS) > "$@"

clean-remove-man:
	-$(RM) -f $(man1_MANS) $(man2_MANS) $(man3_MANS) $(man5_MANS) $(man7_MANS) $(man8_MANS)


# DAEMON CONFIGURATION
#
#  The following support daemon configuration files

#  Convert @foo@ int the .conf and .init.d files to path names
edit_conf_init_d = sed \
	-e 's|@SILK_DATA_ROOTDIR[@]|$(SILK_DATA_ROOTDIR)|g' \
	-e 's|@localstatedir[@]|$(localstatedir)|g' \
	-e 's|@sbindir[@]|$(sbindir)|g' \
	-e 's|@sysconfdir[@]|$(sysconfdir)|g'


# Rules to create the .conf files used by daemons and to install the
# files into $(prefix)/share/silk/etc/
#
conf_file_dir = $(pkgdatadir)/etc

make-conf-files: Makefile
	@list='$(conf_files)'; for p in $$list; do \
	  if test -f "$$p.in"; then d=; else d="$(srcdir)/"; fi; \
	  echo " Creating $$p from $$d$$p.in" ; \
	  rm -f $$p $$p.tmp ; \
	  $(edit_conf_init_d) "$$d$$p.in" > $$p.tmp ; \
	  mv $$p.tmp $$p ; \
	done

install-conf-files: $(conf_files)
	@$(NORMAL_INSTALL)
	$(mkinstalldirs) $(DESTDIR)$(conf_file_dir)
	@list='$(conf_files)'; for p in $$list; do \
	  if test -f "$$p"; then d=; else d="$(srcdir)/"; fi; \
	  f="`echo $$p | sed -e 's,^.*/,,;$(transform)'`"; \
	  echo " $(INSTALL_DATA) $$d$$p $(DESTDIR)$(conf_file_dir)/$$f"; \
	  $(INSTALL_DATA) $$d$$p $(DESTDIR)$(conf_file_dir)/$$f; \
	done

uninstall-conf-files:
	@$(NORMAL_UNINSTALL)
	@list='$(conf_files)'; for p in $$list; do \
	  f="`echo $$p | sed -e 's,^.*/,,;$(transform)'`"; \
	  echo " rm -f $(DESTDIR)$(conf_file_dir)/$$f"; \
	  rm -f $(DESTDIR)$(conf_file_dir)/$$f; \
	done


# Rules to create the .init.d files used by daemons and to install the
# files into $(prefix)/share/silk/etc/init.d/
#
init_d_scripts_dir = $(pkgdatadir)/etc/init.d

make-init-d-files: Makefile
	@list='$(init_d_scripts)'; for p in $$list; do \
	  if test -f "$$p.in"; then d=; else d="$(srcdir)/"; fi; \
	  echo " Creating $$p from $$d$$p.in" ; \
	  rm -f $$p $$p.tmp ; \
	  $(edit_conf_init_d) "$$d$$p.in" > $$p.tmp ; \
	  chmod +x $$p.tmp ; \
	  mv $$p.tmp $$p ; \
	done

install-init-d-scripts: $(init_d_scripts)
	@$(NORMAL_INSTALL)
	$(mkinstalldirs) $(DESTDIR)$(init_d_scripts_dir)
	@list='$(init_d_scripts)'; for p in $$list; do \
	  if test -f "$$p"; then d=; else d="$(srcdir)/"; fi; \
	  f="`echo $$p | sed -e 's,^.*/,,;s,\.init\.d$$,,;$(transform)'`"; \
	  echo " $(INSTALL_SCRIPT) $$d$$p $(DESTDIR)$(init_d_scripts_dir)/$$f"; \
	  $(INSTALL_SCRIPT) $$d$$p $(DESTDIR)$(init_d_scripts_dir)/$$f; \
	done

uninstall-init-d-scripts:
	@$(NORMAL_UNINSTALL)
	@list='$(init_d_scripts)'; for p in $$list; do \
	  f="`echo $$p | sed -e 's,^.*/,,;s,\.init\.d$$,,;$(transform)'`"; \
	  echo " rm -f $(DESTDIR)$(init_d_scripts_dir)/$$f"; \
	  rm -f $(DESTDIR)$(init_d_scripts_dir)/$$f; \
	done


# Rules to build various files used during testing.  To actually build
# these files, add the appropriate variable(s) to check_DATA
#
SILK_TESTBAGS = $(top_builddir)/tests/made-bag-files
$(SILK_TESTBAGS):
	cd $(top_builddir)/tests && $(MAKE) made-bag-files

SILK_TESTDATA = $(top_builddir)/tests/made-test-data
$(SILK_TESTDATA):
	cd $(top_builddir)/tests && $(MAKE) check

SILK_TESTPDU = $(top_builddir)/tests/small.pdu
$(SILK_TESTPDU):
	cd $(top_builddir)/tests && $(MAKE) small.pdu

SILK_TESTSCAN =	$(top_builddir)/tests/scandata.rwf
$(SILK_TESTSCAN):
	cd $(top_builddir)/tests && $(MAKE) scandata.rwf

SILK_SENDRCVDATA = $(top_builddir)/tests/made-sendrcv-data
$(SILK_SENDRCVDATA):
	cd $(top_builddir)/tests && $(MAKE) made-sendrcv-data

SILK_TESTSETS = $(top_builddir)/tests/made-set-files
$(SILK_TESTSETS):
	cd $(top_builddir)/tests && $(MAKE) made-set-files

# Ensure the local 'tests' directory exists
SILK_TESTSDIR = ./tests/touch-dir
$(SILK_TESTSDIR):
	test -d ./tests || mkdir ./tests
	touch $@



# Set defaults to use for the testing harness used by "make check"
#
AM_TESTS_ENVIRONMENT = \
	srcdir=$(srcdir) ; export srcdir ; \
	top_srcdir=$(top_srcdir) ; export top_srcdir ; \
	top_builddir=$(top_builddir) ; export top_builddir ;
PL_LOG_COMPILER = $(PERL)
AM_PL_LOG_FLAGS = -I$(top_srcdir)/tests -w

LOG_COMPILER = $(PL_LOG_COMPILER)
AM_LOG_FLAGS = $(AM_PL_LOG_FLAGS)

clean-remove-tests-touch-dir:
	-rm -f $(SILK_TESTSDIR)

# A rule to rebuild all the automatically generated tests
# This will rebuild all the test files in tests/
sk-make-silktests: all $(check_PROGRAMS) $(check_DATA) $(srcdir)/tests/make-tests.pl
	$(AM_TESTS_ENVIRONMENT) $(LOG_COMPILER) $(AM_LOG_FLAGS) $(srcdir)/tests/make-tests.pl



.PHONY: clean-remove-man clean-remove-tests-touch-dir \
	make-conf-files install-conf-files uninstall-conf-files \
	make-init-d-files install-init-d-scripts uninstall-init-d-scripts \
	sk-make-silktests
