#! /usr/bin/perl -w
# MD5: ed793b053fe922dd2b4f0af9ca02b3e5
# TEST: ./rwbagtool --minimize ../../tests/bag1-v6.bag ../../tests/bag3-v6.bag | ../rwbag/rwbagcat

use strict;
use SiLKTests;

my $rwbagtool = $ENV{RWBAGTOOL} || './rwbagtool';
my $rwbagcat = check_silk_app('rwbagcat');
my %file;
$file{v6bag1} = get_data_or_exit77('v6bag1');
$file{v6bag3} = get_data_or_exit77('v6bag3');
check_features(qw(ipv6));
my $cmd = "$rwbagtool --minimize $file{v6bag1} $file{v6bag3} | $rwbagcat";
my $md5 = "ed793b053fe922dd2b4f0af9ca02b3e5";

check_md5_output($md5, $cmd);
