#! /usr/bin/perl -w
# MD5: 8cc1e2da40266083cf9ae28b7ceb3631
# TEST: ../rwcut/rwcut --fields=sip --no-title --num-rec=200 --delimited ../../tests/data-v6.rwf | ./rwpmaplookup --map-file=../../tests/ip-map-v6.pmap --zero-pad-ip --fields=key,value,input

use strict;
use SiLKTests;

my $rwpmaplookup = $ENV{RWPMAPLOOKUP} || './rwpmaplookup';
my $rwcut = check_silk_app('rwcut');
my %file;
$file{v6_ip_map} = get_data_or_exit77('v6_ip_map');
$file{v6data} = get_data_or_exit77('v6data');
my $cmd = "$rwcut --fields=sip --no-title --num-rec=200 --delimited $file{v6data} | $rwpmaplookup --map-file=$file{v6_ip_map} --zero-pad-ip --fields=key,value,input";
my $md5 = "8cc1e2da40266083cf9ae28b7ceb3631";

check_md5_output($md5, $cmd);
