#! /usr/bin/perl -w
#
#
# RCSIDENT("$SiLK: rwpollexec-set-noarchive.pl 6ed5a5c04fbe 2013-01-31 20:17:06Z mthomas $")

use strict;
use SiLKTests;
use File::Temp ();


# prefix any existing PYTHONPATH with the proper directories
check_python_bin();

# create our tempdir
my $tmpdir = make_tempdir();

# the command that wraps rwpollexec
my $rwpollexec_py = "$SiLKTests::PYTHON $srcdir/tests/rwpollexec-daemon.py";
my $cmd = join " ", ("$rwpollexec_py",
                     ($ENV{SK_TESTS_VERBOSE} ? "--verbose" : ()),
                     #"--log-level=debug",
                     "--return 0",
                     "--return 1",
                     "--signal 9",
                     "--term 0",
                     "--term 1",
                     "--hang",
                     "--return 0",
                     "--return 250",
                     "--signal 3",
                     "--term 0",
                     "--term 127",
                     "--hang",
                     "--basedir=$tmpdir",
                     "--no-archive",
                     "--",
                     "--flat-archive",
                     "--polling-interval=3",
                     "--command \"$rwpollexec_py --exec %s\"",
                     "--timeout TERM,3",
                     "--timeout KILL,5"
    );

my @expected_archive = qw();
my @expected_error   = qw(1 2 4 5 7 8 10 11);

# run it and check the MD5 hash of its output
check_md5_output('ba7517a640382f4281b605f572bdaaa6', $cmd);


# the following directories should be empty
my @empty_dirs = qw(incoming);
for my $d (map {"$tmpdir/$_"} @empty_dirs) {
    next unless -d $d;
    unless (opendir D, $d) {
        warn "ERROR: Cannot open directory '$d': $!\n";
        next;
    }
    while (my $f = readdir(D)) {
        next if $f =~ /^\.\.?$/;
        die "ERROR: Found unexpected file '$d/$f'\n";
    }
    closedir D;
}

# verify files are in the archive directory
my $archive_dir = "$tmpdir/archive";
unless (opendir D, $archive_dir) {
    die "ERROR: Cannot open directory '$archive_dir': $!\n";
}
my %expected;
for my $f (@expected_archive) {
    $expected{$f} = 1;
}
while (my $f = readdir(D)) {
    next if $f =~ /^\.\.?$/;
    if ($expected{$f}) {
        delete $expected{$f};
    }
    else {
        die "ERROR: Found unexpected file '$archive_dir/$f'\n";
    }
}
if (keys %expected) {
    die "ERROR: Missing file '",
        join("', '", map {"$archive_dir/$_"} keys %expected), "'\n";
}
closedir D;

# verify files are in the error directory
my $error_dir = "$tmpdir/error";
unless (opendir D, $error_dir) {
    die "ERROR: Cannot open directory '$error_dir': $!\n";
}
%expected=();
for my $f (@expected_error) {
    $expected{$f} = 1;
}
while (my $f = readdir(D)) {
    next if $f =~ /^\.\.?$/;
    if ($expected{$f}) {
        delete $expected{$f};
    }
    else {
        die "ERROR: Found unexpected file '$error_dir/$f'\n";
    }
}
if (keys %expected) {
    die "ERROR: Missing file '",
        join("', '", map {"$error_dir/$_"} keys %expected), "'\n";
}
closedir D;

