#! /usr/bin/perl -w
#
#
# RCSIDENT("$SiLK: rwflowappend-append-bad.pl 6ed5a5c04fbe 2013-01-31 20:17:06Z mthomas $")

use strict;
use SiLKTests;
use File::Temp ();


# find the apps we need.  this will exit 77 if they're not available
my $rwcat = check_silk_app('rwcat');
my $rwfilter = check_silk_app('rwfilter');

# find the data files we use as sources, or exit 77
my %file;
$file{empty} = get_data_or_exit77('empty');

# prefix any existing PYTHONPATH with the proper directories
check_python_bin();

# create our tempdir
my $tmpdir = make_tempdir();

# create the two files
my %input_files = (
    invalid => File::Temp::mktemp("$tmpdir/in-S8_20090212.01.XXXXXX"),
    empty   => File::Temp::mktemp("$tmpdir/in-S8_20090212.01.XXXXXX"),
    );

# create the invalid file and write the file name into the file
open F, ">$input_files{invalid}"
    or die "ERROR: Unable to open '$input_files{invalid}: $!\n";
print F $input_files{invalid};
close F;

# copy the empty file into place
system("cp", $file{empty}, $input_files{empty})
    and die "ERROR: Cannot copy file to '$input_files{empty}'\n";

# the command that wraps rwflowpack
my $cmd = join " ", ("$SiLKTests::PYTHON $srcdir/tests/rwflowappend-daemon.py",
                     ($ENV{SK_TESTS_VERBOSE} ? "--verbose" : ()),
                     #"--log-level=debug",
                     "--copy $input_files{invalid}:incoming",
                     "--copy $input_files{empty}:incoming",
                     "--basedir=$tmpdir",
                     "--daemon-timeout=15",
                     "--",
                     "--polling-interval=5",
    );

# run it and check the MD5 hash of its output
check_md5_output('345fb9a3ae9d8b91097b19d981663f99', $cmd);


# the following directories should be empty
my @empty_dirs = qw(root incoming);
for my $d (map {"$tmpdir/$_"} @empty_dirs) {
    next unless -d $d;
    unless (opendir D, $d) {
        warn "ERROR: Cannot open directory '$d': $!\n";
        next;
    }
    while (my $f = readdir(D)) {
        next if $f =~ /^\.\.?$/;
        die "ERROR: Found unexpected file '$d/$f'\n";
    }
}

# verify files are in the archive directory
my $archive_dir = "$tmpdir/archive/in/2009/02/12/";
die "ERROR: Missing archive directory '$archive_dir'\n"
    unless -d $archive_dir;
for my $k ('empty') {
    my $f = $input_files{$k};
    $f =~ s,.*/,$archive_dir,;
    die "ERROR: Missing archive file '$f'\n"
        unless -f $f;
}

# verify files are in the error directory
my $error_dir = "$tmpdir/error/";
die "ERROR: Missing  directory '$error_dir'\n"
    unless -d $error_dir;
for my $k ('invalid') {
    my $f = $input_files{$k};
    $f =~ s,.*/,$error_dir,;
    die "ERROR: Missing error file '$f'\n"
        unless -f $f;
}

exit 0;
