% Quick Setup Guide for super_mediator

<!--
    Copyright (C) 2014-2024 Carnegie Mellon University
    See license information in LICENSE.txt.
-->
<!--
    @DISTRIBUTION_STATEMENT_BEGIN@
    Super Mediator 1.10.0

    Copyright 2023 Carnegie Mellon University.

    NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
    INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
    UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
    AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF FITNESS FOR
    PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS OBTAINED FROM USE OF
    THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF
    ANY KIND WITH RESPECT TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT
    INFRINGEMENT.

    Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or
    contact permission@sei.cmu.edu for full terms.

    [DISTRIBUTION STATEMENT A] This material has been approved for public
    release and unlimited distribution.  Please see Copyright notice for
    non-US Government use and distribution.

    GOVERNMENT PURPOSE RIGHTS - Software and Software Documentation
    Contract No.: FA8702-15-D-0002
    Contractor Name: Carnegie Mellon University
    Contractor Address: 4500 Fifth Avenue, Pittsburgh, PA 15213
    The Government's rights to use, modify, reproduce, release, perform,
    display, or disclose this software are restricted by paragraph (b)(2) of
    the Rights in Noncommercial Computer Software and Noncommercial Computer
    Software Documentation clause contained in the above identified
    contract. No restrictions apply after the expiration date shown
    above. Any reproduction of the software or portions thereof marked with
    this legend must also reproduce the markings.

    This Software includes and/or makes use of Third-Party Software each
    subject to its own license.

    DM23-2316
    @DISTRIBUTION_STATEMENT_END@
-->

This tutorial is a step-by-step guide of setting up [yaf](/yaf2/index.html)
and **super_mediator**.
For a detailed tutorial on **super_mediator** and the different configuration
options, see [this tutorial](sm_guide.html). This particular tutorial takes
the DPI data
produced by **yaf** and imports the data into a MySQL database.
This also enables DNS deduplication in **super_mediator**
This tutorial does not give an example of
how to setup SiLK.  See [this page](/yaf2/libyaf/yaf_sm_silk.html) for a
tutorial that includes [SiLK](/silk/index.html).

Install Procedure {#install}
============================

Install prerequisites {#tools}
------------------------------

    yum groupinstall "Development Tools"
    yum install libpcap-devel pcre-devel mysql-server* mysql-devel*

    *RHEL7 mariadb-server mariadb-devel

Build libfixbuf:

    tar -xvzf libfixbuf-1.7.0.tar.gz
    cd libfixbuf-1.7.0
    ./configure
    make
    make install

Build **yaf**:

    tar -xvzf yaf-2.7.0.tar.gz
    cd yaf-2.7.0
    ./configure --enable-applabel --enable-plugins
    make
    make install

Build **super_mediator**:

    tar -xvzf super_mediator-1.2.0.tar.gz
    cd super_mediator-1.2.0
    ./configure --with-mysql
    make
    make install

Setup mysqld {#mysql}
=====================

    service [mysqld|mariadb] start

Setup a password for the root user:

    /usr/bin/mysqladmin -u root password '<SuperSecretPassword>'

Login to the database (It will prompt you for the password you created in the
last step):

    mysql -u root -p

Create the database you intend to use for **super_mediator**:

    mysql> create database smediator;

Create a user for **super_mediator** to access the database:

    mysql> CREATE USER 'mediator'@'localhost' IDENTIFIED BY '<SuperSecretPassword>';

Giver permissions to user to access only the smediator database:

    mysql> GRANT ALL ON smediator.* TO mediator@'localhost';

Create MySQL Tables {#tables}
=============================

Use super_table_creator to create all the tables in your database:

    /usr/local/bin/super_table_creator --name mediator --pass=<SuperSecretPassword>\
     --database=smediator
    /usr/local/bin/super_table_creator --name mediator --pass=<SuperSecretPassword> \
    --database=smediator --dns-dedup


Configure **super_mediator** {#sm}
==================================

Create output directories:

    mkdir -p /data/smediator/dpi
    mkdir -p /data/smediator/dns


Create your super_mediator.conf file.  One is installed by default into
/usr/local/etc.  The following one will get you started (you should add your
&lt;SuperSecretPassword&gt;):

    COLLECTOR TCP
       PORT 18000
    COLLECTOR END

    #dedup process
    EXPORTER TEXT
       PATH "/data/smediator/dns/yaf2dns"
       DELIMITER "|"
       ROTATE 1200
       DNS_DEDUP_ONLY
       LOCK
       MYSQL_USER "mediator"
       MYSQL_PASSWORD "<SuperSecretPassword>"
       MYSQL_TABLE "dns-dedup"
       MYSQL_DATABASE "smediator"
    EXPORTER END

    #dpi 2 database
    EXPORTER TEXT
       PATH "/data/smediator/dpi"
       ROTATE 1200
       MULTI_FILES
       DPI_ONLY
       LOCK
       MYSQL_USER "mediator"
       MYSQL_PASSWORD "<SuperSecretPassword>"
       MYSQL_DATABASE "smediator"
    EXPORTER END

    DNS_DEDUP
       MAX_HIT_COUNT 5000
    DNS_DEDUP END

    LOGLEVEL DEBUG

    LOG "/var/log/super_mediator.log"

    PIDFILE "/data/super_mediator.pid"

Start the Tools {#start}
========================

Start **super_mediator**

    super_mediator -c /usr/local/etc/super_mediator.conf --daemonize

Confirm **super_mediator** is running:

    ps -ef | grep super

If **super_mediator** is not running, check for any errors:

    cat /var/log/super_mediator.log

Start **YAF**:

    mkdir /var/log/yaf

    export LTDL_LIBRARY_PATH=/usr/local/lib/yaf

Run **YAF** over PCAP file:

    /usr/local/bin/yaf
    --in <PCAP FILE> \
    --ipfix tcp \
    --out localhost \
    --log /var/log/yaf/yaf.log \
    --verbose \
    --silk \
    --verbose \
    --ipfix-port=18000 \
    --applabel --max-payload 2048 \
    --plugin-name=/usr/local/lib/yaf/dpacketplugin.so

*OR* Run **YAF** on interface eth0:

    /usr/local/bin/yaf
    --in eth0 --live pcap \
    --ipfix tcp \
    --out localhost \
    --log /var/log/yaf/yaf.log \
    --verbose \
    --silk \
    --verbose \
    --ipfix-port=18000 \
    --applabel --max-payload 2048 \
    --plugin-name=/usr/local/lib/yaf/dpacketplugin.so
