/*
 *  Copyright (C) 2012-2024 Carnegie Mellon University
 *  See license information in LICENSE.txt.
 */
/*
 *  mediator_core.h
 *
 *  IPFIX mediator for filtering, DNS deduplication, and other mediator-like
 *  things.
 *
 *  ------------------------------------------------------------------------
 *  Authors: Emily Sarneso
 *  ------------------------------------------------------------------------
 *  @DISTRIBUTION_STATEMENT_BEGIN@
 *  Super Mediator 1.10.0
 *
 *  Copyright 2023 Carnegie Mellon University.
 *
 *  NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
 *  INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
 *  UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
 *  AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF FITNESS FOR
 *  PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS OBTAINED FROM USE OF
 *  THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF
 *  ANY KIND WITH RESPECT TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT
 *  INFRINGEMENT.
 *
 *  Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or
 *  contact permission@sei.cmu.edu for full terms.
 *
 *  [DISTRIBUTION STATEMENT A] This material has been approved for public
 *  release and unlimited distribution.  Please see Copyright notice for
 *  non-US Government use and distribution.
 *
 *  GOVERNMENT PURPOSE RIGHTS - Software and Software Documentation
 *  Contract No.: FA8702-15-D-0002
 *  Contractor Name: Carnegie Mellon University
 *  Contractor Address: 4500 Fifth Avenue, Pittsburgh, PA 15213
 *  The Government's rights to use, modify, reproduce, release, perform,
 *  display, or disclose this software are restricted by paragraph (b)(2) of
 *  the Rights in Noncommercial Computer Software and Noncommercial Computer
 *  Software Documentation clause contained in the above identified
 *  contract. No restrictions apply after the expiration date shown
 *  above. Any reproduction of the software or portions thereof marked with
 *  this legend must also reproduce the markings.
 *
 *  This Software includes and/or makes use of Third-Party Software each
 *  subject to its own license.
 *
 *  DM23-2316
 *  @DISTRIBUTION_STATEMENT_END@
 *  ------------------------------------------------------------------------
 */

#include "mediator_templates.h"
#include "mediator_inf.h"
#include "mediator_ctx.h"

typedef fbSession_t *(*md_sess_init_fn)(
    fbSession_t  *session,
    GError      **err,
    uint8_t       stats,
    gboolean      metadata_export);

typedef struct mdTmplContext_st {
    uint16_t   tid;
    uint16_t   ie;
    size_t     num_elem;
} mdTmplContext_t;

/* The template context for an incoming template is set to this value when it
 * contains both sourceIPv6Address and destinationIPv6Address. */
extern const void *smTemplateContainsIPv6Address;

fbInfoModel_t *
mdInfoModel(
    void);

fbSession_t *
mdInitExporterSession(
    fbSession_t  *session,
    GError      **err,
    uint8_t       stats,
    gboolean      metadata_export);

fbSession_t *
mdInitExporterSessionDNSDedupOnly(
    fbSession_t  *session,
    GError      **err,
    uint8_t       stats,
    gboolean      metadata_export);

fbSession_t *
mdInitExporterSessionDedupOnly(
    fbSession_t  *session,
    GError      **err,
    uint8_t       stats,
    gboolean      metadata_export);

fbSession_t *
mdInitExporterSessionDNSRROnly(
    fbSession_t  *session,
    GError      **err,
    uint8_t       stats,
    gboolean      metadata_export);

fbSession_t *
mdInitExporterSessionFlowOnly(
    fbSession_t  *session,
    GError      **err,
    uint8_t       stats,
    gboolean      metadata_export);

fbSession_t *
mdInitExporterSessionSSLDedupOnly(
    fbSession_t  *session,
    GError      **err,
    uint8_t       stats,
    gboolean      metadata_export);

#if HAVE_SPREAD
fbSession_t *
mdInitSpreadExporterSession(
    fbSession_t  *session,
    gboolean      dedup,
    GError      **err);
#endif /* if HAVE_SPREAD */
fbSession_t *
mdInitCollectorSession(
    GError **err);

#if HAVE_SPREAD
gboolean
mdSetSpreadExportTemplate(
    fBuf_t            *fbuf,
    fbSpreadParams_t  *sp,
    uint16_t           tid,
    char             **groups,
    int                num_groups,
    GError           **err);
#endif /* if HAVE_SPREAD */

gboolean
mdSetExportTemplate(
    fBuf_t    *fbuf,
    uint16_t   tid,
    GError   **err);

void
mdPrintIP4Address(
    char      *ipaddr_buf,
    uint32_t   ip);

gboolean
mdOptionsCheck(
    fBuf_t       **fbuf,
    uint16_t      *tid,
    fbTemplate_t **tmpl,
    GError       **err);

gboolean
mdForwardOptions(
    mdContext_t        *ctx,
    md_collect_node_t  *collector,
    GError            **err,
    uint16_t            tid);

gboolean
mdForwardTombstone(
    mdContext_t        *ctx,
    md_collect_node_t  *collector,
    uint16_t            tid,
    GError            **err);

gboolean
mdForwardStats(
    mdContext_t        *ctx,
    md_collect_node_t  *collector,
    GError            **err);

gboolean
mdIgnoreRecord(
    mdContext_t  *ctx,
    fBuf_t       *fbuf,
    GError      **err);

gboolean
mdForwardDNSRR(
    mdContext_t  *ctx,
    fBuf_t       *fbuf,
    gboolean      is_ipv6,
    GError      **err);

gboolean
mdForwardDedup(
    mdContext_t  *ctx,
    fBuf_t       *fbuf,
    GError      **err);

gboolean
mdForwardDNSDedup(
    mdContext_t  *ctx,
    fBuf_t       *fbuf,
    GError      **err);

gboolean
mdForwardDedupCustom(
    mdContext_t      *ctx,
    mdTmplContext_t  *tctx,
    fBuf_t           *fbuf,
    GError          **err);

gboolean
mdForwardSSLDedup(
    mdContext_t  *ctx,
    fBuf_t       *fbuf,
    GError      **err);

gboolean
mdForwardSSLCert(
    mdContext_t  *ctx,
    fBuf_t       *fbuf,
    GError      **err);

uint16_t
mdConvertToSiLK(
    const mdFullFlow_t  *flow);

gboolean
mdForwardFlow(
    mdContext_t         *ctx,
    md_main_template_t  *rec,
    uint16_t             tid,
    gboolean             is_ipv6,
    GError             **err);

void
mdDecodeAndClear(
    mdContext_t         *ctx,
    md_main_template_t  *rec,
    uint16_t             tid);

void
mdMainDecode(
    mdContext_t   *ctx,
    mdFullFlow_t  *flow);

void
mdCleanUP(
    mdFullFlow_t  *flow);

void
mdCleanUpSSLCert(
    yaf_newssl_cert_t  *cert);

mdFieldList_t *
mdNewFieldList(
    void);

mdFieldList_t *
mdCreateFieldList(
    mdAcceptFilterField_t   field);

void
mdSetFieldListDecoratorJSON(
    mdFieldList_t  *list);

void
mdSetFieldListDecoratorCustom(
    mdFieldList_t  *list,
    char            delimiter);

void
mdSetFieldListDecoratorBasic(
    mdFieldList_t  *list,
    char            delimiter);

mdFieldList_t *
mdCreateBasicFlowList(
    gboolean   payload,
    gboolean   obdomain);

mdFieldList_t *
mdCreateIndexFlowList(
    void);

void
attachHeadToDLL(
    mdDLL_t **head,
    mdDLL_t **tail,
    mdDLL_t  *newEntry);

void
detachThisEntryOfDLL(
    mdDLL_t **head,
    mdDLL_t **tail,
    mdDLL_t  *entryToDetach);

void
detachHeadOfSLL(
    mdSLL_t **head,
    mdSLL_t **toRemove);

void
attachHeadToSLL(
    mdSLL_t **head,
    mdSLL_t  *newEntry);
