/*
 *  Copyright (C) 2012-2024 Carnegie Mellon University
 *  See license information in LICENSE.txt.
 */
/*
 *  mediator_dns.h
 *
 *  header file for mediator_dns.c
 *
 *  ------------------------------------------------------------------------
 *  Authors: Emily Sarneso
 *  ------------------------------------------------------------------------
 *  @DISTRIBUTION_STATEMENT_BEGIN@
 *  Super Mediator 1.10.0
 *
 *  Copyright 2023 Carnegie Mellon University.
 *
 *  NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
 *  INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
 *  UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
 *  AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF FITNESS FOR
 *  PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS OBTAINED FROM USE OF
 *  THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF
 *  ANY KIND WITH RESPECT TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT
 *  INFRINGEMENT.
 *
 *  Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or
 *  contact permission@sei.cmu.edu for full terms.
 *
 *  [DISTRIBUTION STATEMENT A] This material has been approved for public
 *  release and unlimited distribution.  Please see Copyright notice for
 *  non-US Government use and distribution.
 *
 *  GOVERNMENT PURPOSE RIGHTS - Software and Software Documentation
 *  Contract No.: FA8702-15-D-0002
 *  Contractor Name: Carnegie Mellon University
 *  Contractor Address: 4500 Fifth Avenue, Pittsburgh, PA 15213
 *  The Government's rights to use, modify, reproduce, release, perform,
 *  display, or disclose this software are restricted by paragraph (b)(2) of
 *  the Rights in Noncommercial Computer Software and Noncommercial Computer
 *  Software Documentation clause contained in the above identified
 *  contract. No restrictions apply after the expiration date shown
 *  above. Any reproduction of the software or portions thereof marked with
 *  this legend must also reproduce the markings.
 *
 *  This Software includes and/or makes use of Third-Party Software each
 *  subject to its own license.
 *
 *  DM23-2316
 *  @DISTRIBUTION_STATEMENT_END@
 *  ------------------------------------------------------------------------
 */

#include "mediator_templates.h"
#include "mediator_util.h"


/* Maximum DNS Type checked by the DNS DEDUP code */
#define MD_DNS_DD_MAX_TYPE  33

/* md_dns_dedup_state_t is defined in mediator_ctx.h */

typedef struct md_type_hashtab_st md_type_hashtab_t;


#if 0
md_dns_cqueue_t *
md_new_dns_queue(
    void);
#endif  /* 0 */

md_dns_dedup_state_t *
md_new_dns_dedup_state(
    void);

void
md_dns_dedup_configure_state(
    md_dns_dedup_state_t  *state,
    int                   *dedup_list,
    int                    max_hit,
    int                    flush_timeout,
    gboolean               lastseen,
    smFieldMap_t          *map,
    gboolean               export_name);

#if 0
void
md_dns_destroy_tab(
    md_dns_dedup_state_t  *state);
#endif  /* 0 */

void
md_dns_reset_dedup(
    md_dns_dedup_state_t  *state,
    uint64_t               ctime);

gboolean
md_dns_flush_queue(
    md_export_node_t  *exp,
    mdConfig_t        *md_config,
    GError           **err);

gboolean
md_dns_dedup_free_state(
    mdConfig_t        *cfg,
    md_export_node_t  *state,
    GError           **err);

void
md_dns_dedup_print_stats(
    md_dns_dedup_state_t  *state,
    char                  *exp_name);

#if 0
void
md_dns_flush_tab(
    md_type_hashtab_t     *nodeTab,
    md_dns_dedup_state_t  *state,
    uint64_t               ctime,
    gboolean               flush_all);
#endif  /* 0 */

void
md_add_dns_node(
    mdContext_t       *ctx,
    md_export_node_t  *exp,
    mdFullFlow_t      *flow);

void
md_dns_flush_all_tab(
    md_dns_dedup_state_t  *state,
    uint64_t               ctime,
    gboolean               flush_all);
