/*
 *  Copyright (C) 2012-2024 Carnegie Mellon University
 *  See license information in LICENSE.txt.
 */
/*
 *  mediator_inf.h
 *
 *  IPFIX mediator for filtering, DNS deduplication, and other mediator-like
 *  things
 *
 *  ------------------------------------------------------------------------
 *  Authors: Emily Sarneso
 *  ------------------------------------------------------------------------
 *  @DISTRIBUTION_STATEMENT_BEGIN@
 *  Super Mediator 1.10.0
 *
 *  Copyright 2023 Carnegie Mellon University.
 *
 *  NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
 *  INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
 *  UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
 *  AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF FITNESS FOR
 *  PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS OBTAINED FROM USE OF
 *  THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF
 *  ANY KIND WITH RESPECT TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT
 *  INFRINGEMENT.
 *
 *  Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or
 *  contact permission@sei.cmu.edu for full terms.
 *
 *  [DISTRIBUTION STATEMENT A] This material has been approved for public
 *  release and unlimited distribution.  Please see Copyright notice for
 *  non-US Government use and distribution.
 *
 *  GOVERNMENT PURPOSE RIGHTS - Software and Software Documentation
 *  Contract No.: FA8702-15-D-0002
 *  Contractor Name: Carnegie Mellon University
 *  Contractor Address: 4500 Fifth Avenue, Pittsburgh, PA 15213
 *  The Government's rights to use, modify, reproduce, release, perform,
 *  display, or disclose this software are restricted by paragraph (b)(2) of
 *  the Rights in Noncommercial Computer Software and Noncommercial Computer
 *  Software Documentation clause contained in the above identified
 *  contract. No restrictions apply after the expiration date shown
 *  above. Any reproduction of the software or portions thereof marked with
 *  this legend must also reproduce the markings.
 *
 *  This Software includes and/or makes use of Third-Party Software each
 *  subject to its own license.
 *
 *  DM23-2316
 *  @DISTRIBUTION_STATEMENT_END@
 *  ------------------------------------------------------------------------
 */

#include "mediator_templates.h"
#include "mediator_ctx.h"

/* Names passed to mdNewTable() and for CSV output. */
#define FTP_DEFAULT              "ftp"
#define SSH_DEFAULT              "ssh"
#define SMTP_DEFAULT             "smtp"
#define DNS_DEFAULT              "dns"
#define TFTP_DEFAULT             "tftp"
#define HTTP_DEFAULT             "http"
#define IMAP_DEFAULT             "imap"
#define IRC_DEFAULT              "irc"
#define SIP_DEFAULT              "sip"
#define MYSQL_DEFAULT            "mysql"
#define SLP_DEFAULT              "slp"
#define POP3_DEFAULT             "pop3"
#define RTSP_DEFAULT             "rtsp"
#define NNTP_DEFAULT             "nntp"
#define SSL_DEFAULT              "tls"
#define DHCP_DEFAULT             "dhcp"
#define P0F_DEFAULT              "p0f"
#define IPSET_DEFAULT            "ipset"
#define PMAP_DEFAULT             "prefixmap"
#define SILK_TYPE_SENSOR_DEFAULT "silk_type_sensor"
#define INDEX_DEFAULT            "flow"
#define DNS_DEDUP_DEFAULT        "dns"
#define FLOW_STATS_DEFAULT       "flowstats"
#define YAF_STATS_DEFAULT        "yaf_stats"
#define DNP_DEFAULT              "dnp"
#define RTP_DEFAULT              "rtp"
#define MODBUS_DEFAULT           "modbus"
#define ENIP_DEFAULT             "enip"

mdFlowExporter_t *
mdNewFlowExporter(
    mdTransportType_t   type);

mdFlowCollector_t *
mdNewFlowCollector(
    mdTransportType_t   mode,
    const char         *name);

gboolean
mdCollectorsInit(
    mdConfig_t         *md,
    md_collect_node_t  *collector,
    GError            **err);

void
mdInterruptListeners(
    mdConfig_t  *cfg);

void
mdCollectorSetInSpec(
    mdFlowCollector_t  *collector,
    const char         *inspec);

void
mdCollectorSetDeleteFiles(
    mdFlowCollector_t  *collector,
    gboolean            delete);

void
mdCollectorSetPollTime(
    mdFlowCollector_t  *collector,
    const char         *poll_time);

void
mdCollectorSetDecompressDir(
    mdFlowCollector_t  *collector,
    const char         *path);

void
mdCollectorSetMoveDir(
    mdFlowCollector_t  *collector,
    const char         *move_dir);

void
mdCollectorSetLockMode(
    mdFlowCollector_t  *collector,
    gboolean            lockmode);

md_collect_node_t *
mdCollectorFindListener(
    md_collect_node_t  *collector,
    fbListener_t       *listener);

void
mdCollectorSetPort(
    mdFlowCollector_t  *collector,
    const char         *port);

gboolean
mdCollectorSetSilkProbe(
    mdFlowCollector_t  *collector,
    const char         *probe_name,
    gboolean            use_vlan,
    GError            **err);

void
mdCollectorAddSpreadGroup(
    mdFlowCollector_t  *collector,
    const char         *group,
    int                 group_no);

char *
mdCollectorGetName(
    md_collect_node_t  *node);

uint8_t
mdCollectorGetID(
    md_collect_node_t  *node);

gboolean
mdCollectorVerifySetup(
    mdFlowCollector_t  *collector,
    GError            **err);

void *
mdNewTable(
    const char  *table);

void *
mdGetTable(
    int   id);

void
mdBuildDefaultTableHash(
    void);

gboolean
mdInsertTableItem(
    void  *table_name,
    int    val);

void
mdInsertDPIFieldItem(
    mdFlowExporter_t  *exporter,
    int                ie);

void
mdExporterSetPort(
    mdFlowExporter_t  *exporter,
    const char        *port);

void
mdExporterSetHost(
    mdFlowExporter_t  *exporter,
    const char        *host);

void
mdExporterSetRotate(
    mdFlowExporter_t  *exporter,
    uint32_t           rotate);

void
mdExporterSetDelim(
    mdFlowExporter_t  *exporter,
    const char        *delim);

void
mdExporterSetDPIDelim(
    mdFlowExporter_t  *exporter,
    const char        *delim);

void
mdExporterSetFileSpec(
    mdFlowExporter_t  *exporter,
    const char        *spec);

void
mdExporterFree(
    mdFlowExporter_t  *exporter);

void
mdExporterSetLock(
    mdFlowExporter_t  *exporter);

void
mdExporterDedupPerFlow(
    mdFlowExporter_t  *exporter);

void
mdExporterSetRemoveEmpty(
    mdFlowExporter_t  *exporter);

gboolean
mdExporterVerifySetup(
    mdFlowExporter_t  *exporter);

void
mdExporterSetName(
    mdFlowExporter_t  *exporter,
    const char        *name);

void
mdExporterGZIPFiles(
    mdFlowExporter_t  *exporter);

gboolean
mdExporterSetDPIOnly(
    mdFlowExporter_t  *exporter);

gboolean
mdExporterSetFlowOnly(
    mdFlowExporter_t  *exporter);

void
mdExporterSetDNSDeDup(
    mdFlowExporter_t  *exporter);

void
mdExporterSetDeDupConfig(
    mdFlowExporter_t  *exporter);

void
mdExporterSetSSLDeDupConfig(
    mdFlowExporter_t  *exporter);

gboolean
mdExporterSetSSLDeDupOnly(
    mdFlowExporter_t  *exporter,
    gboolean           dedup_only);

gboolean
mdExporterGetDNSDedupStatus(
    mdFlowExporter_t  *exporter);

void
mdExporterSetDNSRespOnly(
    mdFlowExporter_t  *exporter);

gboolean
mdExporterSetDNSDeDupOnly(
    mdFlowExporter_t  *exporter);

void
mdExporterSetStats(
    mdFlowExporter_t  *exporter,
    uint8_t            mode);

void
mdExporterSetNoFlowStats(
    mdFlowExporter_t  *exporter);

void
mdExporterSetJson(
    mdFlowExporter_t  *exporter);

void
mdExporterSetNoIndex(
    mdFlowExporter_t  *exporter,
    gboolean           val);

void
mdExporterSetPrintHeader(
    mdFlowExporter_t  *exporter);

void
mdExporterSetEscapeChars(
    mdFlowExporter_t  *exporter);

gboolean
mdExportMultiFiles(
    mdFlowExporter_t  *exporter);

int
mdExporterGetType(
    mdFlowExporter_t  *exporter);

void
mdExporterSetTimestampFiles(
    mdFlowExporter_t  *exporter);

void
mdExporterSetRemoveUploaded(
    mdFlowExporter_t  *exporter);

gboolean
mdExporterSetMatchesIPSet(
    mdFlowExporter_t  *exporter,
    const char        *ipset_path,
    const char        *set_name,
    GError           **err);

gboolean
mdExporterSetPrefixMap(
    mdFlowExporter_t  *exporter,
    const char        *pmap_path,
    const char        *map_name,
    GError           **err);

void
mdExportCustomList(
    mdFlowExporter_t  *exporter,
    mdFieldList_t     *list);

void
mdExporterCustomListDPI(
    mdFlowExporter_t  *exporter);

void
mdExporterSetId(
    mdFlowExporter_t  *exporter,
    uint8_t            id);

gboolean
mdExporterCompareNames(
    mdFlowExporter_t  *exporter,
    const char        *name);

void
mdExporterSetSSLConfig(
    mdFlowExporter_t  *exporter,
    uint32_t          *list,
    int                type);

gboolean
mdExporterSetDNSRROnly(
    mdFlowExporter_t  *exporter,
    int                mode);

gboolean
mdExporterAddMySQLInfo(
    mdFlowExporter_t  *exporter,
    const char        *user,
    const char        *password,
    const char        *db_name,
    const char        *db_host,
    const char        *table);

void
mdInterruptFlowSource(
    mdConfig_t  *cfg);


int
mdExporterWriteFlow(
    mdConfig_t        *cfg,
    mdFlowExporter_t  *exporter,
    mdFullFlow_t      *flow,
    GError           **err);

gboolean
mdSendTombstoneRecord(
    mdContext_t  *ctx,
    GError      **err);

gboolean
mdExporterWriteOptions(
    mdConfig_t        *cfg,
    mdFlowExporter_t  *exporter,
    uint8_t           *rec,
    size_t             rec_length,
    uint16_t           tid,
    GError           **err);

gboolean
mdExporterWriteDnsDedup(
    mdConfig_t        *cfg,
    mdFlowExporter_t  *exporter,
    uint16_t           tid,
    uint8_t           *rec,
    size_t             rec_length,
    GError           **err);


gboolean
mdExporterWriteDNSRRRecord(
    mdConfig_t        *cfg,
    mdFlowExporter_t  *exporter,
    uint16_t           tid,
    gboolean           is_ipv6,
    uint8_t           *rec,
    size_t             rec_length,
    GError           **err);

gboolean
mdCollectorWait(
    mdContext_t  *ctx,
    GError      **err);

gboolean
mdCollectorRestartListener(
    mdConfig_t         *cfg,
    md_collect_node_t  *collector,
    GError            **err);

gboolean
mdCollectorStartListeners(
    mdConfig_t         *cfg,
    md_collect_node_t  *collector,
    GError            **err);

gboolean
mdExportersInit(
    mdConfig_t        *cfg,
    md_export_node_t  *node,
    GError           **err);

gboolean
mdExporterRestart(
    mdConfig_t        *cfg,
    mdFlowExporter_t  *exp,
    GError           **err);

void
mdExporterUpdateStats(
    mdConfig_t  *cfg,
    gboolean     dedup);

gboolean
mdExporterDestroy(
    mdConfig_t  *cfg,
    GError     **err);

void
mdCollectorDestroy(
    mdConfig_t  *cfg,
    gboolean     active);


int
mdExporterDPIFlowPrint(
    mdFlowExporter_t  *exporter,
    mdFullFlow_t      *flow,
    const char        *index_str,
    size_t             index_len,
    GError           **err);

gboolean
mdExporterTextDNSPrint(
    mdFlowExporter_t  *exporter,
    yaf_dnsQR_t       *dns);

GString *
mdExporterJsonDNSPrint(
    mdFlowExporter_t  *exporter,
    yaf_dnsQR_t       *dnsqrflow);

gboolean
mdExporterDPIGetIndexStr(
    mdFlowExporter_t  *exporter,
    mdFullFlow_t      *flow);

fBuf_t *
mdCollectorSpread(
    mdConfig_t  *cfg,
    GError     **err);

gboolean
mdExporterConnectionReset(
    mdConfig_t  *cfg,
    GError     **err);

gboolean
mdExportDNSRR(
    mdConfig_t        *cfg,
    mdFlowExporter_t  *exporter,
    mdFullFlow_t      *flow,
    uint16_t           tid,
    GError           **err);

void
mdExporterSetMetadataExport(
    mdFlowExporter_t  *exporter);

/** print functions */
int
mdCustomFlowPrint(
    mdFieldList_t     *list,
    mdFullFlow_t      *flow,
    mdFlowExporter_t  *exporter,
    GError           **err);

md_collect_node_t *
mdCollectorGetNode(
    fBuf_t  *fbuf);

void
mdCollectorUpdateStats(
    mdConfig_t  *cfg);

gboolean
mdExporterDedupFileOpen(
    mdConfig_t        *cfg,
    mdFlowExporter_t  *exporter,
    FILE             **file,
    char             **last_file,
    const char        *prefix,
    uint64_t          *rotate);


void
mdExporterDedupFileClose(
    mdFlowExporter_t  *exporter,
    FILE              *fp,
    char              *last_file);

gboolean
mdExporterSSLCertRecord(
    mdConfig_t           *cfg,
    mdFlowExporter_t     *exporter,
    FILE                 *cert_file,
    yaf_newssl_cert_t    *ssl,
    yaf_ssl_full_cert_t  *fullcert,
    uint8_t              *issuer,
    size_t                issuer_len,
    uint8_t               cert_no,
    GError              **err);

gboolean
mdExporterWriteSSLDedupRecord(
    mdConfig_t        *cfg,
    mdFlowExporter_t  *exporter,
    uint16_t           tid,
    uint8_t           *rec,
    size_t             rec_length,
    GError           **err);

gboolean
mdExporterWriteDedupRecord(
    mdConfig_t        *cfg,
    md_export_node_t  *enode,
    FILE              *fp,
    md_dedup_t        *rec,
    const char        *prefix,
    uint16_t           int_tid,
    uint16_t           ext_tid,
    GError           **err);

gboolean
mdExporterSetSSLSHA1Hash(
    mdFlowExporter_t  *exporter);

gboolean
mdExporterSetSSLMD5Hash(
    mdFlowExporter_t  *exporter);

char *
mdExporterGetName(
    mdFlowExporter_t  *exporter);

void
mdExporterSetMovePath(
    mdFlowExporter_t  *exporter,
    const char        *path);

void
mdExporterSetNoFlow(
    mdFlowExporter_t  *exporter);

gboolean
mdExporterDedupOnly(
    mdFlowExporter_t  *exporter);

gboolean
mdExporterGetJson(
    mdFlowExporter_t  *exporter);
