/*
 *  Copyright (C) 2012-2024 Carnegie Mellon University
 *  See license information in LICENSE.txt.
 */
/*
 *  mediator_print.h
 *
 *  header file for mediator_print.c
 *
 *  ------------------------------------------------------------------------
 *  Authors: Emily Sarneso
 *  ------------------------------------------------------------------------
 *  @DISTRIBUTION_STATEMENT_BEGIN@
 *  Super Mediator 1.10.0
 *
 *  Copyright 2023 Carnegie Mellon University.
 *
 *  NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
 *  INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
 *  UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
 *  AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF FITNESS FOR
 *  PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS OBTAINED FROM USE OF
 *  THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF
 *  ANY KIND WITH RESPECT TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT
 *  INFRINGEMENT.
 *
 *  Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or
 *  contact permission@sei.cmu.edu for full terms.
 *
 *  [DISTRIBUTION STATEMENT A] This material has been approved for public
 *  release and unlimited distribution.  Please see Copyright notice for
 *  non-US Government use and distribution.
 *
 *  GOVERNMENT PURPOSE RIGHTS - Software and Software Documentation
 *  Contract No.: FA8702-15-D-0002
 *  Contractor Name: Carnegie Mellon University
 *  Contractor Address: 4500 Fifth Avenue, Pittsburgh, PA 15213
 *  The Government's rights to use, modify, reproduce, release, perform,
 *  display, or disclose this software are restricted by paragraph (b)(2) of
 *  the Rights in Noncommercial Computer Software and Noncommercial Computer
 *  Software Documentation clause contained in the above identified
 *  contract. No restrictions apply after the expiration date shown
 *  above. Any reproduction of the software or portions thereof marked with
 *  this legend must also reproduce the markings.
 *
 *  This Software includes and/or makes use of Third-Party Software each
 *  subject to its own license.
 *
 *  DM23-2316
 *  @DISTRIBUTION_STATEMENT_END@
 *  ------------------------------------------------------------------------
 */

#include "mediator_templates.h"

gboolean
mdPrintDecimal(
    mdBuf_t  *buf,
    size_t   *bufsize,
    char      delimiter,
    int       decimal);

gboolean
mdPrintCollectorName(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintSIP(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintDIP(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintTOS(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintRTOS(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);


gboolean
mdPrintSTIME(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintETIME(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintDuration(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintRTT(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintProto(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);
gboolean
mdPrintSPort(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintDPort(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintPackets(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintRPackets(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintBytes(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintRBytes(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintIFlags(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintUFlags(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintRIFlags(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintRUFlags(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintAttributes(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintRAttributes(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintMAC(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintDSTMAC(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintTCPSeq(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintRTCPSeq(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintVLAN(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintVLANINT(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintApp(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintEntropy(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintREntropy(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintEnd(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintRDHCPVC(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintDHCPVC(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintRDHCPFP(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintDHCPFP(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintOSNAME(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintROSNAME(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintOSVersion(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintROSVersion(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintOSFingerprint(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintROSFingerprint(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintOBDomain(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintIngress(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintEgress(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintDataBytes(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintITime(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintSTDITime(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintTCPURG(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintSmallPkts(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintNonEmptyPkts(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintLargePkts(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintFirstNonEmpty(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintMaxPacketSize(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintSTDPayLen(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintFirstEight(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintRDataBytes(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintRITime(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintRSTDITime(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintRTCPURG(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintRSmallPkts(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintRNonEmptyPkts(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintRLargePkts(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintRFirstNonEmpty(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintRMaxPacketSize(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintRSTDPayLen(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintFlowKeyHash(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintSIPINT(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintDIPINT(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintSTIMEMS(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintETIMEMS(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintISN(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintRISN(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintMPLS1(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintMPLS2(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintMPLS3(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintNone(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintMPTCPSeq(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);


gboolean
mdPrintMPTCPToken(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintMPTCPMss(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintMPTCPId(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintMPTCPFlags(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

size_t
mdPrintBasicFlow(
    mdFullFlow_t  *flow,
    FILE          *fp,
    char           delimiter,
    GError       **err);

gboolean
mdPrintPayload(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintRPayload(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintPayloadJSON(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintRPayloadJSON(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

void
mdPrintBasicHeader(
    GString  *rstr,
    char      delimiter);

/**
 * mdPrintStats
 *
 * print a YAF stats message to the given exporter
 *
 */
size_t
mdPrintStats(
    yaf_stats_option_t  *stats,
    char                *name,
    FILE                *lfp,
    char                 delim,
    gboolean             no_stats,
    GError             **err);

int
mdPrintDNSRecord(
    FILE      *fp,
    mdBuf_t   *buf,
    char       delimiter,
    uint8_t   *record,
    gboolean   base64,
    gboolean   print_last,
    gboolean   escape_chars,
    GError   **err);

int
mdPrintDNSRRRecord(
    mdBuf_t   *buf,
    FILE      *fp,
    char       delimiter,
    uint8_t   *rec,
    gboolean   is_ipv6,
    gboolean   base64,
    gboolean   escape_chars,
    GError   **err);

gboolean
mdPrintEscapeChars(
    mdBuf_t        *mdbuf,
    size_t         *rem,
    const uint8_t  *buf,
    size_t          buflen,
    char            delimiter);

gboolean
mdPrintBasicList(
    mdBuf_t        *buf,
    GString        *index_str,
    fbBasicList_t  *bl,
    char            delimiter,
    gboolean        hex,
    gboolean        escape);

gboolean
mdPrintVariableLength(
    mdBuf_t        *mdbuf,
    size_t         *brem,
    const uint8_t  *buf,
    size_t          buflen,
    char            delimiter,
    gboolean        hex,
    gboolean        escape);

int
mdPrintDedupRecord(
    FILE        *fp,
    mdBuf_t     *buf,
    md_dedup_t  *rec,
    char         delimiter,
    GError     **err);

int
mdPrintSSLDedupRecord(
    FILE     *fp,
    mdBuf_t  *buf,
    uint8_t  *rec,
    char      delimiter,
    GError  **err);

void
mdPrintEscapeStrChars(
    GString        *str,
    const uint8_t  *buf,
    size_t          buflen,
    char            delimiter);

gboolean
mdPrintDHCPOptions(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintRevDHCPOptions(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintNDPIMaster(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);

gboolean
mdPrintNDPISub(
    mdFullFlow_t  *flow,
    mdBuf_t       *buf,
    size_t        *bufsize,
    const char    *decorator);
