/*
 *  Copyright 2012-2025 Carnegie Mellon University
 *  See license information in LICENSE.txt.
 */
/*
 *  mediator_print.h
 *
 *  header file for mediator_print.c
 *
 *  ------------------------------------------------------------------------
 *  Authors: Emily Sarneso
 *  ------------------------------------------------------------------------
 *  @DISTRIBUTION_STATEMENT_BEGIN@
 *  super_mediator-1.11
 *
 *  Copyright 2024 Carnegie Mellon University.
 *
 *  NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
 *  INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
 *  UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
 *  AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF FITNESS FOR
 *  PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS OBTAINED FROM USE OF
 *  THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF
 *  ANY KIND WITH RESPECT TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT
 *  INFRINGEMENT.
 *
 *  Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or
 *  contact permission@sei.cmu.edu for full terms.
 *
 *  [DISTRIBUTION STATEMENT A] This material has been approved for public
 *  release and unlimited distribution.  Please see Copyright notice for
 *  non-US Government use and distribution.
 *
 *  This Software includes and/or makes use of Third-Party Software each
 *  subject to its own license.
 *
 *  DM24-1038
 *  @DISTRIBUTION_STATEMENT_END@
 *  ------------------------------------------------------------------------
 */

#include "mediator_templates.h"


/*
 *    Declares `fn_name` with the signature for mdPrint_fn
 */
#define MD_DECLARE_PRINTFN(fn_name)             \
    gboolean                                    \
    fn_name (                                   \
        mdFullFlow_t  *flow,                    \
        mdBuf_t       *buf,                     \
        size_t        *bufsize,                 \
        const char    *decorator)

MD_DECLARE_PRINTFN(mdPrintAppLabel);
MD_DECLARE_PRINTFN(mdPrintAttributes);
MD_DECLARE_PRINTFN(mdPrintAttributesRev);
MD_DECLARE_PRINTFN(mdPrintBytes);
MD_DECLARE_PRINTFN(mdPrintBytesRev);
MD_DECLARE_PRINTFN(mdPrintCollectorName);
MD_DECLARE_PRINTFN(mdPrintDHCPFP);
MD_DECLARE_PRINTFN(mdPrintDHCPFPRev);
MD_DECLARE_PRINTFN(mdPrintDHCPOptions);
MD_DECLARE_PRINTFN(mdPrintDHCPOptionsRev);
MD_DECLARE_PRINTFN(mdPrintDHCPVC);
MD_DECLARE_PRINTFN(mdPrintDHCPVCRev);
MD_DECLARE_PRINTFN(mdPrintDIPINT);
MD_DECLARE_PRINTFN(mdPrintDIPJson);
MD_DECLARE_PRINTFN(mdPrintDIPText);
MD_DECLARE_PRINTFN(mdPrintDPort);
MD_DECLARE_PRINTFN(mdPrintDSTMAC);
MD_DECLARE_PRINTFN(mdPrintDataBytes);
MD_DECLARE_PRINTFN(mdPrintDataBytesRev);
MD_DECLARE_PRINTFN(mdPrintDurationBest);
MD_DECLARE_PRINTFN(mdPrintDurationIncomingJson);
MD_DECLARE_PRINTFN(mdPrintDurationIncomingText);
MD_DECLARE_PRINTFN(mdPrintDurationMicro);
MD_DECLARE_PRINTFN(mdPrintDurationMilli);
MD_DECLARE_PRINTFN(mdPrintDurationNano);
MD_DECLARE_PRINTFN(mdPrintDurationNoFrac);
MD_DECLARE_PRINTFN(mdPrintETimeBest);
MD_DECLARE_PRINTFN(mdPrintETimeEpoch);
MD_DECLARE_PRINTFN(mdPrintETimeEpochMS);
MD_DECLARE_PRINTFN(mdPrintETimeIncomingJson);
MD_DECLARE_PRINTFN(mdPrintETimeIncomingText);
MD_DECLARE_PRINTFN(mdPrintETimeMicro);
MD_DECLARE_PRINTFN(mdPrintETimeMilli);
MD_DECLARE_PRINTFN(mdPrintETimeNano);
MD_DECLARE_PRINTFN(mdPrintETimeNoFrac);
MD_DECLARE_PRINTFN(mdPrintEgress);
MD_DECLARE_PRINTFN(mdPrintEndReason);
MD_DECLARE_PRINTFN(mdPrintEntropy);
MD_DECLARE_PRINTFN(mdPrintEntropyRev);
MD_DECLARE_PRINTFN(mdPrintFirstEight);
MD_DECLARE_PRINTFN(mdPrintFirstNonEmpty);
MD_DECLARE_PRINTFN(mdPrintFirstNonEmptyRev);
MD_DECLARE_PRINTFN(mdPrintFlowKeyHash);
MD_DECLARE_PRINTFN(mdPrintIngress);
MD_DECLARE_PRINTFN(mdPrintInitFlags);
MD_DECLARE_PRINTFN(mdPrintInitFlagsRev);
MD_DECLARE_PRINTFN(mdPrintInterArriveTime);
MD_DECLARE_PRINTFN(mdPrintInterArriveTimeRev);
MD_DECLARE_PRINTFN(mdPrintLargePkts);
MD_DECLARE_PRINTFN(mdPrintLargePktsRev);
MD_DECLARE_PRINTFN(mdPrintMAC);
MD_DECLARE_PRINTFN(mdPrintMPLS1);
MD_DECLARE_PRINTFN(mdPrintMPLS2);
MD_DECLARE_PRINTFN(mdPrintMPLS3);
MD_DECLARE_PRINTFN(mdPrintMPTCPFlags);
MD_DECLARE_PRINTFN(mdPrintMPTCPId);
MD_DECLARE_PRINTFN(mdPrintMPTCPMss);
MD_DECLARE_PRINTFN(mdPrintMPTCPSeq);
MD_DECLARE_PRINTFN(mdPrintMPTCPToken);
MD_DECLARE_PRINTFN(mdPrintMaxPacketSize);
MD_DECLARE_PRINTFN(mdPrintMaxPacketSizeRev);
MD_DECLARE_PRINTFN(mdPrintNDPIMaster);
MD_DECLARE_PRINTFN(mdPrintNDPISub);
MD_DECLARE_PRINTFN(mdPrintNonEmptyPkts);
MD_DECLARE_PRINTFN(mdPrintNonEmptyPktsRev);
MD_DECLARE_PRINTFN(mdPrintNone);
MD_DECLARE_PRINTFN(mdPrintOBDomain);
MD_DECLARE_PRINTFN(mdPrintOSFingerprint);
MD_DECLARE_PRINTFN(mdPrintOSFingerprintRev);
MD_DECLARE_PRINTFN(mdPrintOSNAME);
MD_DECLARE_PRINTFN(mdPrintOSNAMERev);
MD_DECLARE_PRINTFN(mdPrintOSVersion);
MD_DECLARE_PRINTFN(mdPrintOSVersionRev);
MD_DECLARE_PRINTFN(mdPrintPackets);
MD_DECLARE_PRINTFN(mdPrintPacketsRev);
MD_DECLARE_PRINTFN(mdPrintPayloadJson);
MD_DECLARE_PRINTFN(mdPrintPayloadJsonRev);
MD_DECLARE_PRINTFN(mdPrintPayloadText);
MD_DECLARE_PRINTFN(mdPrintPayloadTextRev);
MD_DECLARE_PRINTFN(mdPrintProto);
MD_DECLARE_PRINTFN(mdPrintRTTBest);
MD_DECLARE_PRINTFN(mdPrintRTTIncomingJson);
MD_DECLARE_PRINTFN(mdPrintRTTIncomingText);
MD_DECLARE_PRINTFN(mdPrintRTTMicro);
MD_DECLARE_PRINTFN(mdPrintRTTMilli);
MD_DECLARE_PRINTFN(mdPrintRTTNano);
MD_DECLARE_PRINTFN(mdPrintRTTNoFrac);
MD_DECLARE_PRINTFN(mdPrintSIPINT);
MD_DECLARE_PRINTFN(mdPrintSIPJson);
MD_DECLARE_PRINTFN(mdPrintSIPText);
MD_DECLARE_PRINTFN(mdPrintSPort);
MD_DECLARE_PRINTFN(mdPrintSTDITime);
MD_DECLARE_PRINTFN(mdPrintSTDITimeRev);
MD_DECLARE_PRINTFN(mdPrintSTDPayLen);
MD_DECLARE_PRINTFN(mdPrintSTDPayLenRev);
MD_DECLARE_PRINTFN(mdPrintSTimeBest);
MD_DECLARE_PRINTFN(mdPrintSTimeEpoch);
MD_DECLARE_PRINTFN(mdPrintSTimeEpochMS);
MD_DECLARE_PRINTFN(mdPrintSTimeIncomingJson);
MD_DECLARE_PRINTFN(mdPrintSTimeIncomingText);
MD_DECLARE_PRINTFN(mdPrintSTimeMicro);
MD_DECLARE_PRINTFN(mdPrintSTimeMilli);
MD_DECLARE_PRINTFN(mdPrintSTimeNano);
MD_DECLARE_PRINTFN(mdPrintSTimeNoFrac);
MD_DECLARE_PRINTFN(mdPrintSmallPkts);
MD_DECLARE_PRINTFN(mdPrintSmallPktsRev);
MD_DECLARE_PRINTFN(mdPrintTCPSeq);
MD_DECLARE_PRINTFN(mdPrintTCPSeqRev);
MD_DECLARE_PRINTFN(mdPrintTCPURG);
MD_DECLARE_PRINTFN(mdPrintTCPURGRev);
MD_DECLARE_PRINTFN(mdPrintTOS);
MD_DECLARE_PRINTFN(mdPrintTOSRev);
MD_DECLARE_PRINTFN(mdPrintUnionFlags);
MD_DECLARE_PRINTFN(mdPrintUnionFlagsRev);
MD_DECLARE_PRINTFN(mdPrintVLAN);
MD_DECLARE_PRINTFN(mdPrintVLANINT);

#define mdPrintDurationNoFrac   mdPrintDurationMilli
#define mdPrintRTTNoFrac        mdPrintRTTMilli

void
mdPrintEscapeChars(
    mdBuf_t        *mdbuf,
    const uint8_t  *data,
    size_t          datalen,
    char            delimiter);

gboolean
mdPrintBasicList(
    mdBuf_t        *buf,
    const GString  *index_str,
    fbBasicList_t  *bl,
    char            delimiter,
    gboolean        hex,
    gboolean        escape);

gboolean
mdPrintVariableLength(
    mdBuf_t        *mdbuf,
    const uint8_t  *data,
    size_t          datalen,
    char            delimiter,
    gboolean        hex,
    gboolean        escape);

void
mdPrintBasicHeader(
    GString  *rstr,
    char      delimiter);

/**
 *    Print the basic elements of a Flow record to `fp`.
 *
 *    This function is never called.
 */
size_t
mdPrintBasicFlow(
    mdFullFlow_t  *flow,
    FILE          *fp,
    char           delimiter,
    GError       **err);

/**
 *    Print a YAF process stats record to `fp`.
 */
size_t
mdPrintStats(
    yaf_process_stats_t  *stats,
    char                 *name,
    FILE                 *fp,
    char                  delim,
    gboolean              no_stats,
    GError              **err);

/**
 *    Print a DNS DEDUP record to `fp`.
 */
int
mdPrintDNSRecord(
    FILE      *fp,
    mdBuf_t   *buf,
    char       delimiter,
    uint8_t   *record,
    gboolean   base64,
    gboolean   print_last,
    gboolean   escape_chars,
    GError   **err);

/**
 *    Print a DNS RR record to `fp`.
 */
int
mdPrintDNSRRRecord(
    mdBuf_t   *buf,
    FILE      *fp,
    char       delimiter,
    uint8_t   *rec,
    gboolean   is_ipv6,
    gboolean   base64,
    gboolean   escape_chars,
    GError   **err);

/**
 *    Print a General DEDUP record to `fp`.
 */
int
mdPrintDedupRecord(
    FILE        *fp,
    mdBuf_t     *buf,
    md_dedup_t  *rec,
    char         delimiter,
    GError     **err);

/**
 *    Print an SSL DEDUP record to `fp`.
 */
int
mdPrintSSLDedupRecord(
    FILE     *fp,
    mdBuf_t  *buf,
    uint8_t  *rec,
    char      delimiter,
    GError  **err);
