##  Copyright 2012-2025 Carnegie Mellon University
##  See license information in LICENSE.txt.

##  super_mediator.spec: Generated from super_mediator.spec.in by make.

##  @DISTRIBUTION_STATEMENT_BEGIN@
##  super_mediator-1.11
##
##  Copyright 2024 Carnegie Mellon University.
##
##  NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
##  INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
##  UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
##  AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF FITNESS FOR
##  PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS OBTAINED FROM USE OF
##  THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF
##  ANY KIND WITH RESPECT TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT
##  INFRINGEMENT.
##
##  Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or
##  contact permission@sei.cmu.edu for full terms.
##
##  [DISTRIBUTION STATEMENT A] This material has been approved for public
##  release and unlimited distribution.  Please see Copyright notice for
##  non-US Government use and distribution.
##
##  This Software includes and/or makes use of Third-Party Software each
##  subject to its own license.
##
##  DM24-1038
##  @DISTRIBUTION_STATEMENT_END@

#   The following --with X and --without X options are supported with
#   the default shown in brackets:
#
#   mysql [without]: enables a tool and functions to assist in
#          exporting data to a MySQL or MariaDB database
#   spread [without]: enables building with Spread Toolkit support if
#          libfixbuf was also built with spread support
#
#   silk and skipset are mutually exclusive:
#
#   silk [without]: enables record labeling with SiLK IPSets, Prefix
#          Maps, and Type+Sensor settings similar to rwflowpack.
#   skipset [without]:  enables record labeling with SiLK IPSets.
#

%if %{defined bcond}
%bcond  mysql       0
%bcond  spread      0
%bcond  silk        0
%bcond  skipset     0
%else
%if %{defined bcond_with}
# Default is to build without mysql, spread, silk, and skipset; add
# options to enable them
%bcond_with     mysql
%bcond_with     spread
%bcond_with     silk
%bcond_with     skipset
%endif
%endif

# For each option X, ensure that only one of --with or --without is
# given and set enable_X to 1 if the option should be enabled.

# May either specify --with silk or --with skipset but not both
%if %{with silk}
# "--with silk" was given; check for --with skipset
%{?with_skipset: %{error:Both with_silk and with_skipset}}
%if 0%{!?with_skipset:1}
# enable silk
%define enable_silk 1
%define silk_flags --with-skipset
%endif
%endif
%if %{with skipset}
# both enabled would have been caught above
%if 0%{!?with_silk:1}
# enable skipset only
%define enable_skipset 1
%define silk_flags --with-skipset --without-libsilk
%endif
%endif


%define name    super_mediator
%define version 1.11.2
%define release 0%{?enable_silk:_silk}%{?enable_skipset:_skipset}%{?with_mysql:_mysql}%{?with_spread:_spread}%{?dist}

Summary:        IPFIX Super Mediator for use with the YAF and SiLK tools
Name:           %{name}
Version:        %{version}
Release:        %{release}
Group:          Applications/System
License:        GPLv2
Source:         https://tools.netsa.cert.org/releases/%{name}-%{version}.tar.gz
URL:            https://tools.netsa.cert.org/super_mediator/
Provides:       %{name} == %{version}
Requires:       glib2 >= 2.34.0
Requires:       libfixbuf >= 2.3.0
Requires:       openssl-libs >= 1.0.2
Requires:       zlib
BuildRequires:  systemd-rpm-macros
BuildRequires:  gcc, make, perl-interpreter
BuildRequires:  glib2-devel >= 2.34.0
BuildRequires:  libfixbuf-devel >= 2.3.0
BuildRequires:  openssl-devel >= 1.0.2
BuildRequires:  pkgconfig >= 0.16
BuildRequires:  zlib-devel
%if %{with mysql}
Requires:       mariadb
BuildRequires:  mariadb-devel
%endif
%if %{with spread}
Requires:       libspread
BuildRequires:  libspread-devel
%endif
%if 0%{?enable_silk}
Requires:       silk-common >= 3.0
BuildRequires:  silk-devel >= 3.0
%endif
%if 0%{?enable_skipset}
Requires:       silk-ipset-lib >= 3.0
BuildRequires:  silk-ipset-devel >= 3.0
%endif
Requires(post): /sbin/ldconfig
Requires(postun): /sbin/ldconfig

# To apply a patch to the super_mediator sources: (1)put the patch
# file into the SOURCES directory of your rpmbuild area, (2)uncomment
# the 'Patch0:' line below and replace FILENAME with name of the patch
# file, (3)uncomment the 'patch0' line in the 'prep' section below.
#
# To apply another patch, repeat the process using the next sequential
# number.
#
#Patch0: FILENAME
#Patch1: FILENAME
#Patch2: FILENAME

%description
super_mediator is an IPFIX mediator for use with the YAF and SiLK tools.
It collects and filters YAF output data to various IPFIX collecting processes
and/or csv files. super_mediator can be configured to perform de-duplication
of DNS resource records, SSL certificates, or HTTP header fields as exported
by YAF.

%prep
%setup -q -n %{name}-%{version}
#
# Uncomment the patch<N> line for each patch file named in the
# 'Patch<N>: FILENAME' lines above.
#
#%patch0 -p1
#%patch1 -p1
#%patch2 -p1

%build
%configure \
    --enable-type-export=yes \
    --with-openssl=yes \
    --with-zlib=yes \
    --with-mysql=%{?with_mysql:yes}%{!?with_mysql:no} \
    --with-spread=%{?with_spread:yes}%{!?with_spread:no} \
    %{?silk_flags} %{!?silk_flags:--without-skipset}
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
%{__make}

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_bindir}
%make_install

mkdir -p $RPM_BUILD_ROOT%{_unitdir}
mkdir -p $RPM_BUILD_ROOT%{_libexecdir}/super_mediator
install --mode=0644 etc/super_mediator.conf $RPM_BUILD_ROOT%{_sysconfdir}
install --mode=0644 etc/systemd/super_mediator.service $RPM_BUILD_ROOT%{_unitdir}
install --mode=0644 etc/systemd/super_mediator@.service $RPM_BUILD_ROOT%{_unitdir}
install --mode=0755 etc/systemd/super_mediator_startup $RPM_BUILD_ROOT%{_libexecdir}/super_mediator

%post
/sbin/ldconfig
%systemd_post super_mediator.service

%postun
/sbin/ldconfig
%systemd_postun_with_restart super_mediator.service

%preun
if test -e "/sbin/chkconfig" && chkconfig --list super_mediator 2>/dev/null; then
    /sbin/chkconfig --del super_mediator
fi
%systemd_preun super_mediator.service

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
%doc NEWS README
%{_bindir}/super_mediator
%{?with_mysql:%{_bindir}/super_table_creator}
%{_mandir}/man*/*
%config(noreplace) %{_sysconfdir}/super_mediator.conf
%{_unitdir}/super_mediator.service
%{_unitdir}/super_mediator@.service
%{_libexecdir}/super_mediator/super_mediator_startup

%changelog
