/*
 *  Copyright 2012-2025 Carnegie Mellon University
 *  See license information in LICENSE.txt.
 */
/*
 *  mediator_dedup.h
 *
 *  header file for mediator_dedup.c
 *
 *  ------------------------------------------------------------------------
 *  Authors: Emily Sarneso
 *  ------------------------------------------------------------------------
 *  @DISTRIBUTION_STATEMENT_BEGIN@
 *  super_mediator-1.12
 *
 *  Copyright 2025 Carnegie Mellon University.
 *
 *  NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
 *  INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
 *  UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
 *  AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF FITNESS FOR
 *  PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS OBTAINED FROM USE OF
 *  THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF
 *  ANY KIND WITH RESPECT TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT
 *  INFRINGEMENT.
 *
 *  Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or
 *  contact permission@sei.cmu.edu for full terms.
 *
 *  [DISTRIBUTION STATEMENT A] This material has been approved for public
 *  release and unlimited distribution.  Please see Copyright notice for
 *  non-US Government use and distribution.
 *
 *  This Software includes and/or makes use of Third-Party Software each
 *  subject to its own license.
 *
 *  DM25-0935
 *  @DISTRIBUTION_STATEMENT_END@
 *  ------------------------------------------------------------------------
 */

#include "mediator_templates.h"
#include "mediator_util.h"

typedef struct md_dedup_state_st md_dedup_state_t; /* also in ctx.h */
typedef struct md_dedup_ie_st md_dedup_ie_t;


void
md_dedup_flush_alltab(
    md_export_node_t  *exp,
    const yfTime_t    *ctime,
    gboolean           flush_all);

void
md_dedup_basic_list(
    fbBasicList_t  *bl,
    mdBuf_t        *buf,
    GString        *tstr,
    char            delim,
    gboolean        hex,
    gboolean        escape);

void
md_dedup_basic_list_no_count(
    fbBasicList_t  *bl,
    mdBuf_t        *buf,
    char            delim,
    gboolean        quote,
    gboolean        hex,
    gboolean        escape);

gboolean
md_dedup_flush_queue(
    md_export_node_t  *exp,
    mdConfig_t        *cfg,
    GError           **err);

void
md_dedup_configure_state(
    md_dedup_state_t  *state,
    int                max_hit_count,
    int                flush_timeout,
    gboolean           merge_truncated,
    gboolean           add_export);

md_dedup_state_t *
md_dedup_new_dedup_state(
    void);

md_dedup_ie_t *
md_dedup_add_ie_table(
    md_dedup_state_t  *state,
    char              *prefix,
    smFieldMap_t      *map,
    uint16_t           ie,
    int                sip);

void
md_dedup_add_ie(
    md_dedup_state_t  *state,
    md_dedup_ie_t     *ie_tab,
    uint16_t           ie);

void
md_dedup_lookup_node(
    mdContext_t       *ctx,
    md_export_node_t  *exp,
    mdFullFlow_t      *flow,
    GError           **err);

gboolean
md_dedup_free_state(
    mdConfig_t        *cfg,
    md_export_node_t  *exp,
    GError           **err);

void
md_dedup_print_stats(
    md_dedup_state_t  *state,
    char              *exp_name);

gboolean
md_dedup_add_templates(
    md_dedup_state_t  *state,
    fBuf_t            *fbuf,
    GError           **err);

gboolean
md_dedup_write_dedup(
    mdContext_t       *ctx,
    md_export_node_t  *exp,
    md_dedup_t        *dedup,
    uint16_t           ie,
    GError           **err);
