/*
 *  Copyright 2012-2025 Carnegie Mellon University
 *  See license information in LICENSE.txt.
 */
/*
 *  mediator_dns.h
 *
 *  header file for mediator_dns.c
 *
 *  ------------------------------------------------------------------------
 *  Authors: Emily Sarneso
 *  ------------------------------------------------------------------------
 *  @DISTRIBUTION_STATEMENT_BEGIN@
 *  super_mediator-1.12
 *
 *  Copyright 2025 Carnegie Mellon University.
 *
 *  NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
 *  INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
 *  UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
 *  AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF FITNESS FOR
 *  PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS OBTAINED FROM USE OF
 *  THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF
 *  ANY KIND WITH RESPECT TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT
 *  INFRINGEMENT.
 *
 *  Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or
 *  contact permission@sei.cmu.edu for full terms.
 *
 *  [DISTRIBUTION STATEMENT A] This material has been approved for public
 *  release and unlimited distribution.  Please see Copyright notice for
 *  non-US Government use and distribution.
 *
 *  This Software includes and/or makes use of Third-Party Software each
 *  subject to its own license.
 *
 *  DM25-0935
 *  @DISTRIBUTION_STATEMENT_END@
 *  ------------------------------------------------------------------------
 */

#include "mediator_templates.h"
#include "mediator_util.h"


/* Maximum DNS Type checked by the DNS DEDUP code */
#define MD_DNS_DEDUP_MAX_TYPE       33

/* Default hit count */
#define MD_DNS_DEDUP_DEFAULT_HIT    5000

/* Default flush timeout in seconds */
#define MD_DNS_DEDUP_DEFAULT_FLUSH  300


/* md_dns_dedup_state_t is defined in mediator_ctx.h */

typedef struct md_type_hashtab_st md_type_hashtab_t;


md_dns_dedup_state_t *
md_dns_dedup_new_state(
    void);

void
md_dns_dedup_configure_state(
    md_dns_dedup_state_t  *state,
    int                   *dedup_list,
    int                    max_hit,
    int                    flush_timeout,
    gboolean               lastseen,
    smFieldMap_t          *map,
    gboolean               export_name);

void
md_dns_dedup_reset(
    md_dns_dedup_state_t  *state,
    const yfTime_t        *cur_time);

gboolean
md_dns_dedup_flush_queue(
    md_export_node_t  *exp,
    mdConfig_t        *md_config,
    GError           **err);

gboolean
md_dns_dedup_free_state(
    mdConfig_t        *cfg,
    md_export_node_t  *state,
    GError           **err);

void
md_dns_dedup_print_stats(
    md_dns_dedup_state_t  *state,
    char                  *exp_name);

void
md_dns_dedup_add_node(
    mdContext_t       *ctx,
    md_export_node_t  *exp,
    mdFullFlow_t      *flow);

void
md_dns_dedup_flush_all_tab(
    md_dns_dedup_state_t  *state,
    const yfTime_t        *cur_time,
    gboolean               flush_all);
