/*
 *  Copyright 2012-2025 Carnegie Mellon University
 *  See license information in LICENSE.txt.
 */
/*
 *  mediator_filter.h
 *
 *  ------------------------------------------------------------------------
 *  Authors: Emily Sarneso
 *  ------------------------------------------------------------------------
 *  @DISTRIBUTION_STATEMENT_BEGIN@
 *  super_mediator-1.12
 *
 *  Copyright 2025 Carnegie Mellon University.
 *
 *  NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
 *  INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
 *  UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
 *  AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF FITNESS FOR
 *  PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS OBTAINED FROM USE OF
 *  THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF
 *  ANY KIND WITH RESPECT TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT
 *  INFRINGEMENT.
 *
 *  Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or
 *  contact permission@sei.cmu.edu for full terms.
 *
 *  [DISTRIBUTION STATEMENT A] This material has been approved for public
 *  release and unlimited distribution.  Please see Copyright notice for
 *  non-US Government use and distribution.
 *
 *  This Software includes and/or makes use of Third-Party Software each
 *  subject to its own license.
 *
 *  DM25-0935
 *  @DISTRIBUTION_STATEMENT_END@
 *  ------------------------------------------------------------------------
 */

#include "mediator_ctx.h"
#include "mediator_templates.h"


/* The typedef is also defined in mediator_ctx.h */
typedef struct md_filter_st md_filter_t;
struct md_filter_st {
    md_filter_t            *next;
#if ENABLE_SKIPSET
    mdIPSet_t              *ipset;
#endif
    fieldOperator           oper;
    mdAcceptFilterField_t   field;
    uint8_t                 num_in_list;
    uint32_t                val[MAX_LIST];
};

/* The typedef is also defined in mediator_ctx.h */
typedef struct md_spread_filter_st md_spread_filter_t;
struct md_spread_filter_st {
    md_spread_filter_t  *next;
    char                *group;
    md_filter_t         *filterList;
};


gboolean
mdFilter(
    const md_filter_t   *filter,
    const mdFullFlow_t  *flow,
    uint32_t             obdomain,
    gboolean             and_filter,
    uint8_t              collector_id);

md_filter_t *
md_new_filter_node(
    void);

void
md_free_filter_node(
    md_filter_t  *filter);

#ifdef HAVE_SPREAD

int
mdSpreadExporterFilter(
    const md_spread_filter_t  *sf,
    const mdFullFlow_t        *md_flow,
    char                     **groups);

md_spread_filter_t *
md_new_spread_node(
    void);

void
md_free_spread_node(
    md_spread_filter_t  *filter);

#endif  /* HAVE_SPREAD */
