% Explanation of Super Mediator services

<!--
    Copyright 2024-2025 Carnegie Mellon University
    See license information in LICENSE.txt.
-->
<!--
    @DISTRIBUTION_STATEMENT_BEGIN@
    super_mediator-1.13

    Copyright 2025 Carnegie Mellon University.

    NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
    INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
    UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
    AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF FITNESS FOR
    PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS OBTAINED FROM USE OF
    THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF
    ANY KIND WITH RESPECT TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT
    INFRINGEMENT.

    Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or
    contact permission@sei.cmu.edu for full terms.

    [DISTRIBUTION STATEMENT A] This material has been approved for public
    release and unlimited distribution.  Please see Copyright notice for
    non-US Government use and distribution.

    This Software includes and/or makes use of Third-Party Software each
    subject to its own license.

    DM25-1447
    @DISTRIBUTION_STATEMENT_END@
-->

This page explains the service features included with Super Mediator

# [systemd](#systemd) {#systemd}

On systems that support it, systemd is an option for managing super mediator
services. The implementation of super mediator as a systemd service is
intended to provide an easy transition for those migrating from the init.d
service implementation.

When running a super mediator service for the first time, you must first
modify the configuration file, [**super\_mediator.conf**][sm_conf], with
relevant parameters for your intended use. If you are upgrading from a
previous version of super mediator, your configuration file will have
persisted during the upgrade. The **super\_mediator.conf** file is typically
found in **/etc**.

Once the configuration file is completed, starting super mediator as a
service is the same as starting any other systemd service:

    systemctl start super_mediator.service

Checking the service status and stopping the service are also typical:

    systemctl status super_mediator.service

and:

    systemctl stop super_mediator.service

## [Instantiated Services](#instantiated_services) {#instantiated_services}

With systemd functionality comes the ability to start a super mediator
service as an instance, with a unique configuration per instance.

To start Super Mediator as an instantiated service, you must create a unique
configuration file in the configuration file directory (**/etc**). The
config file should be named **super_mediator.foo.conf** where **foo** is the
name you want to give your instantiated service. Once this is done, you can
start the instantiated service by passing your service name.

For example:

    systemctl start super_mediator@foo.service

starts an instantiated service using the configuration file
**super\_mediator.foo.conf**.

# [init.d](#init.d) {#init.d}

For systems that do not support systemd, the init.d service script is still
available, however this capability is not present when installing via rpm.

Running a super mediator service using init.d is very similar to using
systemd. The **super\_mediator.conf** configuration file must be configured
prior to first use with the parameters you want the service to use. The
configuration file is typically located in **/etc**.

Once your configuration file is complete, you can start the super mediator
service using the following command:

    service super_mediator start

You can stop the service or check its status using:

    service super_mediator stop

and

    service super_mediator status


[sm_conf]:              super_mediator.conf.html


[//]: # (Local variables:)
[//]: # (fill-column: 76)
[//]: # (indent-tabs-mode: nil)
[//]: # (sentence-end-double-space: nil)
[//]: # (tab-width: 8)
[//]: # (End:)
