/*
 *  Copyright 2012-2025 Carnegie Mellon University
 *  See license information in LICENSE.txt.
 */
/*
 *  mediator_core.h
 *
 *  IPFIX mediator for filtering, DNS deduplication, and other mediator-like
 *  things.
 *
 *  ------------------------------------------------------------------------
 *  Authors: Emily Sarneso
 *  ------------------------------------------------------------------------
 *  @DISTRIBUTION_STATEMENT_BEGIN@
 *  super_mediator-1.13
 *
 *  Copyright 2025 Carnegie Mellon University.
 *
 *  NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
 *  INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
 *  UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
 *  AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF FITNESS FOR
 *  PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS OBTAINED FROM USE OF
 *  THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF
 *  ANY KIND WITH RESPECT TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT
 *  INFRINGEMENT.
 *
 *  Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or
 *  contact permission@sei.cmu.edu for full terms.
 *
 *  [DISTRIBUTION STATEMENT A] This material has been approved for public
 *  release and unlimited distribution.  Please see Copyright notice for
 *  non-US Government use and distribution.
 *
 *  This Software includes and/or makes use of Third-Party Software each
 *  subject to its own license.
 *
 *  DM25-1447
 *  @DISTRIBUTION_STATEMENT_END@
 *  ------------------------------------------------------------------------
 */

#include "mediator_templates.h"
#include "mediator_inf.h"
#include "mediator_ctx.h"

typedef fbSession_t *(*md_sess_init_fn)(
    fbSession_t  *session,
    GError      **err,
    uint8_t       stats,
    gboolean      metadata_export);

typedef struct mdTmplContext_st {
    uint16_t             tid;
    uint16_t             dedup_ie;
    uint16_t             num_elem;
    gboolean             is_dedup;

    gboolean             is_metadata_element;
    gboolean             is_metadata_template;

    mdTmplAttributes_t   attr;
} mdTmplContext_t;


fbInfoModel_t *
mdInfoModel(
    void);

/*
 *    Callback passed to mdExporterfBufSetup() whose signature must match
 *    md_sess_init_fn.
 */
fbSession_t *
mdInitExporterSession(
    fbSession_t  *session,
    GError      **err,
    uint8_t       stats,
    gboolean      metadata_export);

/*
 *    Callback passed to mdExporterfBufSetup() whose signature must match
 *    md_sess_init_fn.
 */
fbSession_t *
mdInitExporterSessionDNSDedupOnly(
    fbSession_t  *session,
    GError      **err,
    uint8_t       stats,
    gboolean      metadata_export);

/*
 *    Callback passed to mdExporterfBufSetup() whose signature must match
 *    md_sess_init_fn.
 */
fbSession_t *
mdInitExporterSessionDedupOnly(
    fbSession_t  *session,
    GError      **err,
    uint8_t       stats,
    gboolean      metadata_export);

/*
 *    Callback passed to mdExporterfBufSetup() whose signature must match
 *    md_sess_init_fn.
 */
fbSession_t *
mdInitExporterSessionDNSRROnly(
    fbSession_t  *session,
    GError      **err,
    uint8_t       stats,
    gboolean      metadata_export);

/*
 *    Callback passed to mdExporterfBufSetup() whose signature must match
 *    md_sess_init_fn.
 */
fbSession_t *
mdInitExporterSessionFlowOnly(
    fbSession_t  *session,
    GError      **err,
    uint8_t       stats,
    gboolean      metadata_export);

/*
 *    Callback passed to mdExporterfBufSetup() whose signature must match
 *    md_sess_init_fn.
 */
fbSession_t *
mdInitExporterSessionSSLDedupOnly(
    fbSession_t  *session,
    GError      **err,
    uint8_t       stats,
    gboolean      metadata_export);

#if HAVE_SPREAD
fbSession_t *
mdInitSpreadExporterSession(
    fbSession_t  *session,
    gboolean      dedup,
    GError      **err);
#endif /* if HAVE_SPREAD */

fbSession_t *
mdInitCollectorSession(
    GError **err);

#if HAVE_SPREAD
gboolean
mdSetSpreadExportTemplate(
    fBuf_t            *fbuf,
    fbSpreadParams_t  *sp,
    uint32_t           tid,
    char             **groups,
    int                num_groups,
    GError           **err);
#endif /* if HAVE_SPREAD */

gboolean
mdSetExportTemplate(
    fBuf_t    *fbuf,
    uint32_t   tid,
    GError   **err);

gboolean
mdOptionsCheck(
    fBuf_t          **fbuf,
    uint16_t         *tid,
    fbTemplate_t    **tmpl,
    mdTmplContext_t **tctx,
    GError          **err);

gboolean
mdForwardOptions(
    mdContext_t        *ctx,
    md_collect_node_t  *collector,
    uint16_t            tid,
    GError            **err);

gboolean
mdIgnoreRecord(
    mdContext_t  *ctx,
    fBuf_t       *fbuf,
    GError      **err);

gboolean
mdForwardDNSRR(
    mdContext_t            *ctx,
    const mdTmplContext_t  *tctx,
    fBuf_t                 *fbuf,
    GError                **err);

gboolean
mdForwardDedup(
    mdContext_t            *ctx,
    const mdTmplContext_t  *tctx,
    fBuf_t                 *fbuf,
    GError                **err);

gboolean
mdForwardDNSDedup(
    mdContext_t            *ctx,
    const mdTmplContext_t  *tctx,
    fBuf_t                 *fbuf,
    GError                **err);

gboolean
mdForwardDedupCustom(
    mdContext_t            *ctx,
    const mdTmplContext_t  *tctx,
    fBuf_t                 *fbuf,
    GError                **err);

gboolean
mdForwardSSLDedup(
    mdContext_t            *ctx,
    const mdTmplContext_t  *tctx,
    fBuf_t                 *fbuf,
    GError                **err);

gboolean
mdForwardSSLCert(
    mdContext_t            *ctx,
    const mdTmplContext_t  *tctx,
    fBuf_t                 *fbuf,
    GError                **err);

uint32_t
mdConvertToSiLK(
    const mdFullFlow_t  *flow);

gboolean
mdForwardFlow(
    mdContext_t   *ctx,
    mdFullFlow_t  *flow,
    GError       **err);

void
mdDecodeAndClear(
    mdContext_t   *ctx,
    mdFullFlow_t  *flow);

mdFieldList_t *
mdCreateFieldList(
    mdAcceptFilterField_t   field,
    gboolean                internal);

void
mdSetFieldListDecoratorJSON(
    mdFieldList_t  *list);

void
mdSetFieldListDecoratorCustom(
    mdFieldList_t  *list,
    char            delimiter);

void
mdSetFieldListDecoratorBasic(
    mdFieldList_t  *list,
    char            delimiter);

mdFieldList_t *
mdCreateBasicFieldList(
    gboolean   payload,
    gboolean   obdomain);

mdFieldList_t *
mdCreateIndexFieldList(
    void);

void
attachHeadToDLL(
    mdDLL_t **head,
    mdDLL_t **tail,
    mdDLL_t  *newEntry);

void
detachThisEntryOfDLL(
    mdDLL_t **head,
    mdDLL_t **tail,
    mdDLL_t  *entryToDetach);

void
detachHeadOfSLL(
    mdSLL_t **head,
    mdSLL_t **toRemove);

void
attachHeadToSLL(
    mdSLL_t **head,
    mdSLL_t  *newEntry);
