/*
 *  Copyright 2012-2025 Carnegie Mellon University
 *  See license information in LICENSE.txt.
 */
/*
 *  mediator_json.h
 *
 *  header file for mediator_json.c
 *
 *  ------------------------------------------------------------------------
 *  Authors: Emily Sarneso
 *  ------------------------------------------------------------------------
 *  @DISTRIBUTION_STATEMENT_BEGIN@
 *  super_mediator-1.13
 *
 *  Copyright 2025 Carnegie Mellon University.
 *
 *  NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
 *  INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
 *  UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
 *  AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF FITNESS FOR
 *  PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS OBTAINED FROM USE OF
 *  THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF
 *  ANY KIND WITH RESPECT TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT
 *  INFRINGEMENT.
 *
 *  Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or
 *  contact permission@sei.cmu.edu for full terms.
 *
 *  [DISTRIBUTION STATEMENT A] This material has been approved for public
 *  release and unlimited distribution.  Please see Copyright notice for
 *  non-US Government use and distribution.
 *
 *  This Software includes and/or makes use of Third-Party Software each
 *  subject to its own license.
 *
 *  DM25-1447
 *  @DISTRIBUTION_STATEMENT_END@
 *  ------------------------------------------------------------------------
 */

#include "mediator_templates.h"

gboolean
mdJsonifyEscapeChars(
    mdBuf_t        *mdbuf,
    const uint8_t  *data,
    size_t          datalen);

gboolean
mdJsonifyEscapeCharsGStringAppend(
    GString        *str,
    const uint8_t  *cp,
    size_t          len);

gboolean
mdJsonifyDNSRecord(
    yaf_dnsQR_t  *dns,
    mdBuf_t      *buf);

size_t
mdPrintJsonStats(
    yaf_process_stats_t  *stats,
    const char           *name,
    FILE                 *lfp,
    GError              **er);

size_t
mdPrintJsonTombstone(
    yaf_tombstone_t  *tombstone,
    const char       *name,
    FILE             *lfp,
    GError          **er);


int
mdJsonifyDNSDedupRecord(
    FILE           *fp,
    mdBuf_t        *buf,
    const uint8_t  *record,
    gboolean        print_last,
    gboolean        base64,
    GError        **err);

int
mdJsonifySSLDedupRecord(
    FILE           *fp,
    mdBuf_t        *buf,
    const uint8_t  *rec,
    GError        **err);

int
mdJsonifyDedupRecord(
    FILE        *fp,
    mdBuf_t     *buf,
    const char  *prefix,
    md_dedup_t  *rec,
    GError     **err);

gboolean
mdJsonifyDNSRRRecord(
    md_dnsrr_t  *rec,
    gboolean     is_ipv6,
    mdBuf_t     *buf);

void
mdJsonifySSLCertBase64(
    mdBuf_t             *buf,
    const fbVarfield_t  *cert);
