dnl Copyright (C) 2018 by Carnegie Mellon University.

# ---------------------------------------------------------------------------
# INFOMODEL_AC_COLLECT_REGISTRIES(srcdir, infomodel_dir)
#
#    Create a list of infomodel IE registries located in
#    $srcdir/$infomodel_dir.  Place the list of registry names in
#    INFOMODEL_REGISTRIES.  Place a list of registry names in
#    INFOMODEL_REGISTRY_PREFIXES.  Place a list of registry include
#    files in INFOMODEL_REGISTRY_INCLUDE_FILES.  Place a list of
#    registry include dependencies based from $srcdir in
#    INFOMODEL_REGISTRY_INCLUDES.
#
#    Output variables: INFOMODEL_REGISTRIES INFOMODEL_REGISTRY_PREFIXES
#        INFOMODEL_REGISTRY_INCLUDE_FILES INFOMODEL_REGISTRY_INCLUDES
#
AC_DEFUN([INFOMODEL_AC_COLLECT_REGISTRIES],[
    AC_SUBST(INFOMODEL_REGISTRY_PREFIXES)
    AC_SUBST(INFOMODEL_REGISTRY_INCLUDE_FILES)
    AC_SUBST(INFOMODEL_REGISTRY_INCLUDES)
    AC_SUBST(INFOMODEL_REGISTRIES)

    AC_MSG_CHECKING([for information element files])
    for infomodel_file in [`echo $1/$2/[A-Za-z0-9_]*.xml`]
    do
        [base=`echo "$infomodel_file" | sed 's,^.*/\([^/]*\)\.xml$,\1,'`]
        INFOMODEL_REGISTRIES="$INFOMODEL_REGISTRIES $base.xml"
        INFOMODEL_REGISTRY_PREFIXES="$INFOMODEL_REGISTRY_PREFIXES $base"
        INFOMODEL_REGISTRY_INCLUDES="$INFOMODEL_REGISTRY_INCLUDES $2/$base.i"
        INFOMODEL_REGISTRY_INCLUDE_FILES="$INFOMODEL_REGISTRY_INCLUDE_FILES $base.i"
    done
    AC_MSG_RESULT([$2/{$INFOMODEL_REGISTRY_PREFIXES}])
])
