#! /usr/bin/perl
#
#  This script modifies the HTML man pages generated by pod2html.  It
#  adds a header and footer, and creates links to other man pages.
#

#
use warnings;
use strict;
use File::Temp  qw//;

my $NAME = $0;
$NAME =~ s,.*/,,;

our $old = $ARGV[0];
unless ($old) {
    die "Usage: $NAME <filename>\n\tAdd header and footer to named file\n";
}

open(OLD, '<', $old)
    or die "$NAME: Cannot open '$old' for reading: $!\n";

our ($fh, $new) = File::Temp::tempfile(UNLINK => 1)
    or die "$NAME: Unable to create a temporary file: $!\n";
*NEW = $fh;

do_manpage();

close OLD;
close NEW
    or die "$NAME: Cannot close '$new': $!\n";

rename $new, $old
    or die "$NAME: Cannot rename '$old' to '$new': $!\n";

exit;


sub add_header
{
    my ($title) = @_;

    if ($title)
    {
        $title = "Documentation - $title";
    }
    else
    {
        $title = "Documentation";
    }

    return <<EOF;
<head>
<title>super_mediator - $title</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<link rel="stylesheet" type="text/css" href="../site/style.css" />
</head>
<body>
  <div id="p-body">
    <div id="l-header">
      <img src="../site/sei-logo.png" id="l-sei-logo"
        alt="Software Engineering Institute | Carnegie Mellon&copy;" />
      <div id="l-netsa-logo"><a id="l-netsa-name" href="../index.html"><b>CERT NetSA Security Suite</b></a></div>
      <div id="l-netsa-motto">Monitoring for Large-Scale Networks</div>
      <h1 class="l-page-title">super_mediator</h1>
      <span id="l-subtitle">Documentation</span>
    </div><!-- l-header -->
    <div id="l-content">
      <div id="l-sidebar">
        <div class="p-sidebar-section">
          <h1><a href="index.html">super_mediator</a></h1>
          <ul>
            <li><a href="docs.html">Documentation</a></li>
            <li><a href="download.html">Downloads</a></li>
          </ul>
        </div><!-- p-sidebar-section -->
      </div><!-- l-sidebar -->
EOF
}


sub add_footer
{
    return <<EOF;
    </div><!-- l-content -->
    <div id="l-footer">
      &copy; 2012-2020 Carnegie Mellon University
      <span id="l-contact">
        <a href="https://www.sei.cmu.edu/legal/index.cfm">Legal</a> |
        <a href="https://www.sei.cmu.edu/legal/privacy-notice/index.cfm">Privacy Notice</a> |
        <img alt="email address" src="/site/contact_email.png" />
      </span>
    </div>
  </div><!-- p-body -->
</body>
EOF
}


sub do_manpage
{
    # We'll overwrite this with name of man page
    my $title = '';

    print NEW add_header($title);
    $/ = "";  # read one paragraph at a time
    while (<OLD>) {
        # Remove all <hr>
        s{<hr\b[^>]*>}{}iog;

        # Remove </body>
        s{</body>}{};

        print NEW;
    }

    print NEW add_footer();
}
# do_manpage

