#! /usr/bin/perl
#
#  This script modifies the HTML man pages generated by pod2html.  It
#  creates links to other man pages.
#

#
use warnings;
use strict;
use File::Temp  qw//;

#
use FindBin qw($Bin);
use lib "$Bin";

# Man pages to link to: hard-coding this for now, should generate from
# build the way SiLK does
our $man_re = "(".join("|", map { "\Q$_\E" }
                       qw(
                           super_mediator
                           super_mediator.conf
                           super_table_creator
                       )).")";

my $NAME = $0;
$NAME =~ s,.*/,,;

our $old = $ARGV[0];
unless ($old) {
    die "Usage: $NAME <filename>\n\tAdd header and footer to named file\n";
}

open(OLD, '<', $old)
    or die "$NAME: Cannot open '$old' for reading: $!\n";

our ($fh, $new) = File::Temp::tempfile(UNLINK => 1)
    or die "$NAME: Unable to create a temporary file: $!\n";
*NEW = $fh;

do_manpage();

close OLD;
close NEW
    or die "$NAME: Cannot close '$new': $!\n";

rename $new, $old
    or die "$NAME: Cannot rename '$old' to '$new': $!\n";

exit;


sub do_manpage
{
    # We'll overwrite this with name of man page
    my $title = '';

    # ignore everything until we get to the end of the index, but do
    # cash the title
    my $saw_index = 0;

    # whether we saw the <head>
    my $saw_head = 0;

    $/ = "";  # read one paragraph at a time
    while (<OLD>) {
        # # Downgrade all <Hn> tags by one
        # s{(</?h)(\d)\b([^>]*>)}{$1.($2 +1 ).$3}gieo;

        # Get rid of any mailto: links
        s{<link[^>]+mailto:[^>]+>}{}i;

        # Remove all <hr>
        s{<hr\b[^>]*>}{}iog;

        # # Change <a name> to <a id>
        # s{<a name="}{<a id="}iog;

        # Make links to other man pages
        s{(<b>$man_re\(\d\)</b>)}{<a href="$2.html">$1</a>}og;

        print NEW;
    }
}
# do_manpage
