dnl -*- autoconf -*-
dnl Copyright (C) 2004-2023 by Carnegie Mellon University.
dnl
dnl @OPENSOURCE_HEADER_START@
dnl
dnl Use of the SILK system and related source code is subject to the terms
dnl of the following licenses:
dnl
dnl GNU Public License (GPL) Rights pursuant to Version 2, June 1991
dnl Government Purpose License Rights (GPLR) pursuant to DFARS 252.227.7013
dnl
dnl NO WARRANTY
dnl
dnl ANY INFORMATION, MATERIALS, SERVICES, INTELLECTUAL PROPERTY OR OTHER
dnl PROPERTY OR RIGHTS GRANTED OR PROVIDED BY CARNEGIE MELLON UNIVERSITY
dnl PURSUANT TO THIS LICENSE (HEREINAFTER THE "DELIVERABLES") ARE ON AN
dnl "AS-IS" BASIS. CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY
dnl KIND, EITHER EXPRESS OR IMPLIED AS TO ANY MATTER INCLUDING, BUT NOT
dnl LIMITED TO, WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE,
dnl MERCHANTABILITY, INFORMATIONAL CONTENT, NONINFRINGEMENT, OR ERROR-FREE
dnl OPERATION. CARNEGIE MELLON UNIVERSITY SHALL NOT BE LIABLE FOR INDIRECT,
dnl SPECIAL OR CONSEQUENTIAL DAMAGES, SUCH AS LOSS OF PROFITS OR INABILITY
dnl TO USE SAID INTELLECTUAL PROPERTY, UNDER THIS LICENSE, REGARDLESS OF
dnl WHETHER SUCH PARTY WAS AWARE OF THE POSSIBILITY OF SUCH DAMAGES.
dnl LICENSEE AGREES THAT IT WILL NOT MAKE ANY WARRANTY ON BEHALF OF
dnl CARNEGIE MELLON UNIVERSITY, EXPRESS OR IMPLIED, TO ANY PERSON
dnl CONCERNING THE APPLICATION OF OR THE RESULTS TO BE OBTAINED WITH THE
dnl DELIVERABLES UNDER THIS LICENSE.
dnl
dnl Licensee hereby agrees to defend, indemnify, and hold harmless Carnegie
dnl Mellon University, its trustees, officers, employees, and agents from
dnl all claims or demands made against them (and any related losses,
dnl expenses, or attorney's fees) arising out of, or relating to Licensee's
dnl and/or its sub licensees' negligent use or willful misuse of or
dnl negligent conduct or willful misconduct regarding the Software,
dnl facilities, or other rights or assistance granted by Carnegie Mellon
dnl University under this License, including, but not limited to, any
dnl claims of product liability, personal injury, death, damage to
dnl property, or violation of any laws or regulations.
dnl
dnl Carnegie Mellon University Software Engineering Institute authored
dnl documents are sponsored by the U.S. Department of Defense under
dnl Contract FA8721-05-C-0003. Carnegie Mellon University retains
dnl copyrights in all material produced under this contract. The U.S.
dnl Government retains a non-exclusive, royalty-free license to publish or
dnl reproduce these documents, or allow others to do so, for U.S.
dnl Government purposes only pursuant to the copyright license under the
dnl contract clause at 252.227.7013.
dnl
dnl @OPENSOURCE_HEADER_END@


# ---------------------------------------------------------------------------
# AX_LIB_OPENSSL
#
#   Check for the OpenSSL library (-lssl -lcrypt) and header files.
#
#   Expects two arguments:
#
#   1. First should be "yes", "no", or "auto". "yes" means to fail if OpenSSL
#   cannot be found unless the user explicitly disables it.  "no" means only
#   use OpenSSL when requested by the user. "auto" (or any other value) means
#   to check for OpenSSL unless disabled by the user, but do not error if it
#   is not found.
#
#   2. Second is the help string to print for the --with-openssl argument.
#
#   Output definitions: HAVE_EVP_MD5, HAVE_EVP_MD_FETCH, HAVE_EVP_Q_DIGEST,
#   HAVE_EVP_SHA1, HAVE_EVP_SHA256, HAVE_MD5, HAVE_OPENSSL,
#   HAVE_OPENSSL_EVP_H, HAVE_OPENSSL_MD5_H, HAVE_OPENSSL_SHA_H, HAVE_SHA1,
#   HAVE_SHA256
#
AC_DEFUN([AX_LIB_OPENSSL],[
    default="$1"
    m4_define(openssl_helpstring,[[$2]])

    MD_HAVE_OPENSSL=

    if test "x${default}" = xyes
    then
        request_require=required
    else
        request_require=requested
    fi

    AC_ARG_WITH([openssl],
    [AS_HELP_STRING([--with-openssl@<:@=PREFIX@:>@],dnl
        openssl_helpstring)],[],
    [
        # Option not given, use default
        if test "x${default}" = xyes || test "x${default}" = xno
        then
            with_openssl="${default}"
        fi
    ])

    if test "x${with_openssl}" = xno
    then
        AC_MSG_NOTICE([not checking for OpenSSL])
    else
        AC_MSG_NOTICE([checking for OpenSSL...])
        if test -n "${with_openssl}" && test "x${with_openssl}" != xyes ; then
            LDFLAGS="-L${with_openssl}/lib ${LDFLAGS}"
            CPPFLAGS="-I${with_openssl}/include ${CPPFLAGS}"
        fi

        dnl look for libssl
        AC_CHECK_LIB([crypto], [EVP_Digest],
        [
            MD_HAVE_OPENSSL=yes
            AC_DEFINE(HAVE_OPENSSL, 1, [Define to 1 to enable OpenSSL support])
            LIBS="-lssl -lcrypto ${LIBS}"

            # Additional functions to check for; no error
            AC_CHECK_FUNCS([EVP_Q_digest EVP_MD_fetch EVP_md5 EVP_sha1 EVP_sha256 MD5 SHA1 SHA256])

            AC_CHECK_HEADERS([openssl/evp.h],[],
            [
                if test "x${with_openssl}" != x
                then
                    AC_MSG_ERROR([OpenSSL support ${request_require} but cannot find openssl/evp.h])
                fi
            ])

            # Additional headers to check for; no error
            AC_CHECK_HEADERS([openssl/sha.h openssl/md5.h])
        ],[
            if test "x${with_openssl}" != x
            then
                AC_MSG_ERROR([OpenSSL support ${request_require} but cannot find EVP_Digest()])
            fi
        ])

        if test "x${MD_HAVE_OPENSSL}" = xyes
        then
            AC_MSG_NOTICE([building with OpenSSL support])
        else
            AC_MSG_NOTICE([not building with OpenSSL support])
        fi
    fi
])
