%define name super_mediator
%define version 1.9.1
%define release 0

# The following --with X and --without X options are supported with
# the default shown in brackets:
#
#   type-export [with]: enables template and element metadata records
#   openssl [without]: enables computing hashes of X.509 certificates
#   mysql [without]: enables a tool and functions to assist in
#          exporting data to a MySQL or MariaDB database
#   spread [without]: enables building with Spread Toolkit support if
#          libfixbuf was also built with spread support
#   silk [without]: enables record labeling with SiLK IPSets, Prefix
#          Maps, and Type+Sensor settings similar to rwflowpack.  May
#          not be combined with skipset.
#   skipset [without]:  enables record labeling with SiLK IPSets.
#         May not be combined with silk

# For each option X, ensure that only one of --with or --without is
# given and set enable_X to 1 if the option should be enabled.

# type-export
%{?_with_type_export: %{?_without_type_export: %{error:Both _with_type_export and _without_type_export}}}
%{!?_without_type_export: %define enable_type_export 1}

# openssl
%if 0%{?_with_openssl:1}
%{?_without_openssl: %{error:Both _with_openssl and _without_openssl}}
%{!?_without_openssl: %define enable_openssl 1}
%endif

# mysql
%if 0%{?_with_mysql:1}
%{?_without_mysql: %{error:Both _with_mysql and _without_mysql}}
%{!?_without_mysql: %define enable_mysql 1}
%endif

# spread
%if 0%{?_with_spread:1}
%{?_without_spread: %{error:Both _with_spread and _without_spread}}
%{!?_without_spread: %define enable_spread 1}
%endif

# May either specify --with silk or --with skipset but not both
%if 0%{?_with_silk:1}
# "--with silk" was given; check for --without silk, --with skipset
%{?_without_silk: %{error:Both _with_silk and _without_silk}}
%{?_with_skipset: %{error:Both _with_silk and _with_skipset}}
%if 0%{!?_without_silk:1}
%if 0%{!?_with_skipset:1}
# enable silk
%define enable_silk 1
%define silk_flags --with-skipset
%endif
%endif
%endif
%if 0%{!?_with_silk:1}
%if 0%{?_with_skipset:1}
# "--with skipset" was given; check for --without skipset
%{?_without_skipset:: %{error:Both _with_skipset and _without_skipset}}
# enable skipset only
%if 0%{!?_without_skipset:1}
%define enable_skipset 1
%define silk_flags --with-skipset --without-libsilk
%endif
%endif
%endif


Summary:        IPFIX Super Mediator for use with the YAF and SiLK tools
Name:           %{name}
Version:        %{version}
Release:        %{release}%{?dist}
Group:          Applications/System
License:        GPLv2
Source:         https://tools.netsa.cert.org/releases/%{name}-%{version}.tar.gz
URL:            https://tools.netsa.cert.org/super_mediator/
Provides:       %{name} == %{version}
Requires:       glib2 >= 2.18
Requires:       libfixbuf >= 2.3.0
BuildRequires:  pkgconfig >= 0.8
BuildRequires:  glib2-devel >= 2.18
BuildRequires:  libfixbuf-devel >= 2.3.0
%if 0%{?enable_openssl}
Requires:       openssl-libs >= 1.0.2
BuildRequires:  openssl-devel >= 1.0.2
%endif
%if 0%{?enable_mysql}
%if 0%{?centos} >= 8
BuildRequires:  mariadb-devel >= 5.0
%else
BuildRequires:  mysql-devel >= 5.0
%endif
%endif
%if 0%{?enable_spread}
Requires:       libspread
BuildRequires:  libspread-devel
%endif
%if 0%{?enable_silk}
Requires:       silk-common >= 3.0
BuildRequires:  silk-devel >= 3.0
%endif
%if 0%{?enable_skipset}
Requires:       silk-ipset-lib >= 3.0
BuildRequires:  silk-ipset-devel >= 3.0
%endif
%if 0%{?enable_silk}%{?enable_skipset}
BuildRequires:  lzo-devel
BuildRequires:  snappy-devel
%endif
Requires(post): /sbin/ldconfig, /sbin/chkconfig
Requires(preun): /sbin/chkconfig
Requires(postun): /sbin/ldconfig

%description
super_mediator is an IPFIX mediator for use with the YAF and SiLK tools. 
It collects and filters YAF output data to various IPFIX collecting processes 
and/or csv files. super_mediator can be configured to perform de-duplication 
of DNS resource records, SSL certificates, or HTTP header fields as exported
by YAF.

%prep
%setup -q -n %{name}-%{version}

%build
%configure \
    --enable-type-export=%{?enable_type_export:yes}%{!?enable_type_export:no} \
    --with-openssl=%{?enable_openssl:yes}%{!?enable_openssl:no} \
    --with-mysql=%{?enable_mysql:yes}%{!?enable_mysql:no} \
    --with-spread=%{?enable_spread:yes}%{!?enable_spread:no} \
    %{?silk_flags} %{!?silk_flags:--without-skipset}
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
%{__make}

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_binddir}
%makeinstall

mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/init.d/
install --mode=0755 etc/init.d/super_mediator $RPM_BUILD_ROOT%{_sysconfdir}/init.d/
install --mode=0644 etc/super_mediator.conf $RPM_BUILD_ROOT%{_sysconfdir}

%post
/sbin/ldconfig
function runlvl(){
    ( /sbin/chkconfig --del $1 || true )
    /sbin/chkconfig --add $1
    /sbin/chkconfig --levels 345 $1 on
    /sbin/chkconfig --levels 016 $1 off
}

%postun -p /sbin/ldconfig

%preun
if [ "$1" = 0 ]; then
    /sbin/chkconfig --del yaf
fi

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
%doc NEWS README
%{_bindir}/super_mediator
%{?enable_mysql:%{_bindir}/super_table_creator}
%{_mandir}/*
%config(noreplace) %{_sysconfdir}/super_mediator.conf
%attr(755,root,root) %{_sysconfdir}/init.d/super_mediator

%changelog
