/*
 ** logconfig.h
 ** Generic glib-based logging configuration support
 **
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2005-2007 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Brian Trammell <bht@cert.org>
 **          Tony Cebzanov <tonyc@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU Lesser GPL Rights pursuant to Version 2.1, February 1999 
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 */

/**
 * @file
 *
 * Airframe Logging Configuration Support. Supplies glib log routing to 
 * standard error, file output, and the UNIX syslog facility, and the command 
 * line option processing necessary to use it. Integrates with daeconfig to 
 * ensure proper use of standard error, and to default to standard error or 
 * syslog as appropriate. Use this when your application uses glib logging and 
 * you want to give your users control over where to route logging information 
 * via the command line.
 */

/* idem hack */
#ifndef _AIR_LOGCONFIG_H_
#define _AIR_LOGCONFIG_H_

#include <airframe/autoinc.h>
#include <airframe/airopt.h>

/** GError domain for logconfig errors */
#define LOGC_ERROR_DOMAIN (g_quark_from_string("airframeLogError"))
/** 
 * Logconfig argument error. The user passed in an illegal command-line 
 * argument.
 */
#define LOGC_ERROR_ARGUMENT 1

/**
 * Add an option group for logging configuration to the given option context.
 * This option group defines four options: --log (-l) to specify a logging
 * destination, --loglevel (-L)  to specify the minimum severity of logged
 * messages, --verbose (-v) which is a shortcut for --loglevel debug, and
 * --version (-V) which will print version information and exit the application.
 * 
 * @param aoctx airframe option context
 * @param appname application name to display
 * @param version application version string
 * @return TRUE if successful, FALSE otherwise
 */
gboolean logc_add_option_group(
    AirOptionCtx   *aoctx,
    const char     *appname,
    const char     *version);

/**
 * Set up log routing. Call this after parsing an options context including a
 * GOptionGroup returned from logc_option_group(). This sets up log routing 
 * using logconfig; subsequent glib logging calls will be routed as specified
 * by the user.
 *
 * By default, if the application will fork to the background logging is 
 * routed to standard error; otherwise, it is routed to the "user" syslog 
 * facility. In either case, the default loglevel is warning.
 *
 * @param err an error description
 * @return TRUE on success, FALSE otherwise.
 */
 
gboolean logc_setup(
    GError          **err);

/* end idem */
#endif
