/*
 ** mio_sink_multi.h
 ** Multiple I/O multisink, for output fanout.
 **
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2006 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Brian Trammell <bht@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU Lesser GPL Rights pursuant to Version 2.1, February 1999 
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 */

/**
 * @file
 *
 * MIO multisink initializer and utilities. 
 */

/* idem hack */
#ifndef _AIRFRAME_MIO_SINK_MULTI_H_
#define _AIRFRAME_MIO_SINK_MULTI_H_
#include <airframe/mio.h>

/**
 * Initialize a multisink for writing to multiple subordinate sinks. A 
 * multisink simply distributes its operations (next, close, free) among 
 * its subordinates. This function creates a multisink with all of its 
 * subordinate sinks zeroed - after initializing, each subordinate sink must
 * in turn be initialized by a specific sink initializer.
 *
 *
 * @param sink      pointer to MIOSink to initialize. This MIOSink will 
 *                  be overwritten.
 * @param spec      input specifier to initialize MIOSource with.
 *                  Ignored; may be NULL.
 * @param vsp_type  requested sink pointer type, or MIO_T_ANY for default.
 *                  Must be ANY or MULTISINK.
 * @param cfg       Number of subordinate sinks to allocate
 *                  cast to a void pointer using GUINT_TO_POINTER.
 * @param err       An error description pointer.
 * @return TRUE if the MIOSink was successfully initialized.
 */
gboolean mio_sink_init_multi(
    MIOSink         *sink,
    const char      *spec,
    MIOType         vsp_type,
    void            *cfg,
    GError          **err);

/**
 * Convenience macro to retrieve the subordinate sink count for a 
 * given multisink.
 */
#define mio_smc(_s_) (GPOINTER_TO_UINT((_s_)->cfg))
 
/**
 * Convenience macro to access a given subordinate sink by index for a 
 * given multisink. Evaluates to a structure; use the address operator to
 * get a pointer to the subordinate sink.
 */
#define mio_smn(_s_, _n_) (((MIOSink *)(_s_)->vsp)[(_n_)])

/* end idem */
#endif
