/*
 ** mio_sink_tcp.c
 ** Multiple I/O active UDP datagram sink
 **
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2006 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Brian Trammell <bht@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU Lesser GPL Rights pursuant to Version 2.1, February 1999 
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 */

/**
 * @file
 *
 * MIO active TCP socket sink initializer. Most applications should use the 
 * interface in mio_config.h to access this initializer.
 */

/* idem hack */
#ifndef _AIRFRAME_MIO_SINK_TCP_H_
#define _AIRFRAME_MIO_SINK_TCP_H_
#include <airframe/mio.h>

/**
 * Initialize a sink for writing to an active TCP socket.
 *
 * @param sink      pointer to MIOSink to initialize. This MIOSink will 
 *                  be overwritten.
 * @param spec      input specifier to initialize MIOSource with.
 *                  Must be a service specifier of the form "host[,service]"
 *                  where host is the IPv4 or IPv6 name or address of an
 *                  interface to connect to, and service is a service name 
 *                  or TCP port number to connect to. If omitted, service
 *                  is taken from the cfg paramater.
 * @param vsp_type  requested sink pointer type, or MIO_T_ANY for default.
 * @param cfg       pointer to configuration context. 
 *                  Must be a pointer to a string with the default service 
 *                  name or integer port number.
 * @param err       An error description pointer.
 * @return TRUE if the MIOSink was successfully initialized.
 */
 
gboolean mio_sink_init_tcp(
    MIOSink         *sink,
    const char      *spec,
    MIOType         vsp_type,
    void            *cfg,
    GError          **err);
    
/* end idem */
#endif
