/*
 ** mio_source_udp.c
 ** Multiple I/O passive UDP datagram source
 **
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2006 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Brian Trammell <bht@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU Lesser GPL Rights pursuant to Version 2.1, February 1999 
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 */
 
/**
 * @file
 *
 * MIO passive UDP socket source initializer. Most applications should use the 
 * interface in mio_config.h to access this initializer.
 */

/* idem hack */
#ifndef _AIRFRAME_MIO_SOURCE_UDP_H_
#define _AIRFRAME_MIO_SOURCE_UDP_H_
#include <airframe/mio.h>

/**
 * Initialize a source for reading datagrams from a passive UDP socket.
 *
 * @param source    pointer to MIOSource to initialize. This MIOSource will 
 *                  be overwritten.
 * @param spec      input specifier to initialize MIOSource with.
 *                  Must be a service specifier of the form "[host,]service"
 *                  where host is the IPv4 or IPv6 name or address of an
 *                  interface to bind to, or * to bind to all interfaces, and
 *                  service is a service name or UDP port number to bind to.
 *                  If omitted, host is assumed to be *. If spec is NULL,
 *                  host is assumed to be * and service is taken from the
 *                  cfg paramater.
 * @param vsp_type  requested source pointer type, or MIO_T_ANY for default.
 * @param cfg       pointer to configuration context. 
 *                  Must be a pointer to a string with the default service 
 *                  name or integer port number.
 * @param err       An error description pointer.
 * @return TRUE if the MIOSource was successfully initialized.
 */

gboolean mio_source_init_udp(
    MIOSource       *source,
    const char      *spec,
    MIOType         vsp_type,
    void            *cfg,
    GError          **err);
    
/* end idem */
#endif
