/*
 ** mio_stdio.c
 ** Multiple I/O standard in source / standard out sink
 **
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2006 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Brian Trammell <bht@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU Lesser GPL Rights pursuant to Version 2.1, February 1999 
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 */

/**
 * @file
 *
 * MIO standard input/output initializers. Most applications should use the 
 * interface in mio_config.h to access these initializers.
 */

/* idem hack */
#ifndef _AIRFRAME_MIO_STDIO_H_
#define _AIRFRAME_MIO_STDIO_H_
#include <airframe/mio.h>

/**
 * Initialize a standard input source.
 *
 * @param source    pointer to MIOSource to initialize. This MIOSource will 
 *                  be overwritten.
 * @param spec      input specifier to initialize MIOSource with.
 *                  Only "-" is acceptable for standard input sources.
 * @param vsp_type  requested source pointer type, or MIO_T_ANY for default.
 * @param cfg       pointer to configuration context. 
 *                  This source uses no configuration context; pass NULL.
 * @param err       An error description pointer.
 * @return TRUE if the MIOSource was successfully initialized.
 */
 
gboolean mio_source_init_stdin(
    MIOSource       *source,
    const char      *spec,
    MIOType         vsp_type,
    void            *cfg,
    GError          **err);

/**
 * Initialize a standard output sink.
 *
 * @param sink      pointer to MIOSink to initialize. This MIOSink will 
 *                  be overwritten.
 * @param spec      input specifier to initialize MIOSink with.
 *                  Only "-" is acceptable for standard output sinks.
 * @param vsp_type  requested sink pointer type, or MIO_T_ANY for default.
 * @param cfg       pointer to configuration context. 
 *                  This source uses no configuration context; pass NULL.
 * @param err       An error description pointer.
 * @return TRUE if the MIOSink was successfully initialized.
 */

gboolean mio_sink_init_stdout(
    MIOSink         *sink,
    const char      *spec,
    MIOType         vsp_type,
    void            *cfg,
    GError          **err);

/* end idem */
#endif
