/*
 ** daeconfig.c
 ** Generic daemon configuration support
 **
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2005 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Brian Trammell <bht@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU Lesser GPL Rights pursuant to Version 2.1, February 1999 
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 */

#define _AIRFRAME_SOURCE_
#include <airframe/daeconfig.h>
#include <airframe/airopt.h>

static char *RCSID __attribute__ ((unused)) = 
    "$Id: daeconfig.c 8435 2007-08-14 22:09:11Z bht $";

static gboolean opt_daemon = FALSE;
static gboolean opt_fg = FALSE;

static gboolean did_fork = FALSE;

static gboolean daemon_quit = FALSE;

AirOptionEntry daec_optentries[] = {
    AF_OPTION( "daemon", 'd', 0, AF_OPT_TYPE_NONE, &opt_daemon,
               "Become daemon", NULL ),
    AF_OPTION( "foreground", (char)0, 0, AF_OPT_TYPE_NONE, &opt_fg,
               "Do not fork to background in daemon mode", NULL ),
    AF_OPTION_END
};

gboolean daec_add_option_group(AirOptionCtx *aoctx)
{
    g_assert(aoctx != NULL);
    
    air_option_context_add_group(aoctx, "daemon", "Daemon options:",
                                 "Show help for daemon options", 
                                 daec_optentries);
    
    return TRUE;    
}

gboolean daec_is_daemon() {
    return opt_daemon;
}

gboolean daec_did_fork() {
    return did_fork;
}

gboolean daec_will_fork() {
    return opt_daemon ? (opt_fg ? 0 : 1 ) : 0;
}

void daec_quit() {
    ++daemon_quit;
}

gboolean daec_did_quit() {
    return daemon_quit;
}

gboolean daec_setup(
    GError              **err)
{
    struct sigaction sa, osa;

    /* fork if necessary */
    if (daec_will_fork()) {

        /* fork */
        if (fork()) exit(0);

        /* dissociate from controlling terminal */
        if (setsid() < 0) {
            g_set_error(err, DAEC_ERROR_DOMAIN, DAEC_ERROR_SETUP,
                "setsid() failed: %s", strerror(errno));
            return FALSE;
        }

        /* redirect stdio */
        freopen("/dev/null", "r", stdin);
        freopen("/dev/null", "w", stdout);
        freopen("/dev/null", "w", stderr);

        /* we forked */
        did_fork = TRUE;
    }
    
    /* install quit flag handlers */
    sa.sa_handler = daec_quit;
    sigemptyset(&sa.sa_mask);
    sa.sa_flags = SA_RESTART;
    if (sigaction(SIGINT,&sa,&osa)) {
        g_set_error(err, DAEC_ERROR_DOMAIN, DAEC_ERROR_SETUP,
            "sigaction(SIGINT) failed: %s", strerror(errno));
        return FALSE;
    }

    sa.sa_handler = daec_quit;
    sigemptyset(&sa.sa_mask);
    sa.sa_flags = SA_RESTART;
    if (sigaction(SIGTERM,&sa,&osa)) {
        g_set_error(err, DAEC_ERROR_DOMAIN, DAEC_ERROR_SETUP,
            "sigaction(SIGTERM) failed: %s", strerror(errno));
        return FALSE;
    }

    return TRUE;
}

