/*
 ** mio_internal.h
 ** Multiple I/O internal common prototypes
 **
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2006 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Brian Trammell <bht@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU Lesser GPL Rights pursuant to Version 2.1, February 1999 
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 */

/* idem hack */
#ifndef _AIRFRAME_MIO_INTERNAL_H_
#define _AIRFRAME_MIO_INTERNAL_H_
#include <airframe/mio.h>

gboolean mio_source_next_file_dir(
    MIOSource               *source,
    uint32_t                *flags,
    GError                  **err);

gboolean mio_source_next_file_glob(
    MIOSource               *source,
    uint32_t                *flags,
    GError                  **err);

gboolean mio_source_next_file_single(
    MIOSource               *source,
    uint32_t                *flags,
    GError                  **err);

gboolean mio_source_close_file(
    MIOSource               *source,
    uint32_t                *flags,
    GError                  **err);

gboolean mio_source_check_stdin(
    MIOSource       *source,
    uint32_t        *flags,
    GError          **err);

gboolean mio_source_close_stdin(
    MIOSource       *source,
    uint32_t        *flags,
    GError          **err);

void mio_source_free_file(
    MIOSource       *source);

/* end idem */
#endif
