/*
 ** autoinc.h
 ** Autotools-happy standard library include file
 **
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2005 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Brian Trammell <bht@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU General Public License (GPL) Rights pursuant to Version 2, June 1991
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 */

/** @file
 *  Convenience include file for libyaf.
 */

#ifndef _YAF_AUTOINC_H_
#define _YAF_AUTOINC_H_

#ifdef _YAF_SOURCE_
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#endif

#include <stdio.h>

#if	HAVE_SYS_TYPES_H
#  include <sys/types.h>
#endif

#if	STDC_HEADERS
#  include <stdlib.h>
#  include <stddef.h>
#else
#  if	HAVE_STDLIB_H
#    include <stdlib.h>
#  endif
#  if	HAVE_MALLOC_H
#    include <malloc.h>
#  endif
#endif

#if	HAVE_STRING_H
#  if	!STDC_HEADERS && HAVE_MEMORY_H
#    include <memory.h>
#  endif
#  include <string.h>
#endif

#if	HAVE_INTTYPES_H
#  include <inttypes.h>
#else
#  if	HAVE_STDINT_H
#    include <stdint.h>
#  endif
#endif

#if	HAVE_ERRNO_H
#  include <errno.h>
#endif

#if	HAVE_FCNTL_H
#  include <fcntl.h>
#endif

#if	HAVE_SIGNAL_H
#  include <signal.h>
#endif

#if	HAVE_SIGNAL_H
#  include <signal.h>
#endif

#if	HAVE_GLOB_H
#  include <glob.h>
#endif

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif


#include <pcap.h>

#include <glib.h>
#if GLIB_CHECK_VERSION(2,6,0)
#  include <glib/gstdio.h>
#else
#define g_debug(...)    g_log (G_LOG_DOMAIN,         \
                               G_LOG_LEVEL_DEBUG,    \
                               __VA_ARGS__)
#endif

#ifdef _YAF_SOURCE_
#if YAF_DISABLE_SLABALLOC || !defined g_slice_new0
#define yg_slice_new0(_t_) g_new0(_t_, 1)
#define yg_slice_alloc0(_s_) g_malloc0(_s_)
#else
#define yg_slice_alloc0(_s_) g_slice_alloc0(_s_)
#define yg_slice_new0(_t_) g_slice_new0(_t_)
#endif

#if YAF_DISABLE_SLABALLOC || !defined g_slice_free
#define yg_slice_free(_t_, _p_) g_free(_p_)
#define yg_slice_free1(_s_, _p_) g_free(_p_)
#else
#define yg_slice_free(_t_, _p_) g_slice_free(_t_, _p_)
#define yg_slice_free1(_s_, _p_) g_slice_free1(_s_, _p_)
#endif
#endif

/** the following PRI* macros code was taken from
silk_config.h */
/** PRI* macros for printing */
#if !defined(PRIu32)
/* Assume we either get them all or get none of them. */
#  define PRId32 "d"
#  define PRIi32 "i"
#  define PRIo32 "o"
#  define PRIu32 "u"
#  define PRIx32 "x"
#  define PRIX32 "X"

#  define PRId16 PRId32
#  define PRIi16 PRIi32
#  define PRIo16 PRIo32
#  define PRIu16 PRIu32
#  define PRIx16 PRIx32
#  define PRIX16 PRIX32

#  define PRId8  PRId32
#  define PRIi8  PRIi32
#  define PRIo8  PRIo32
#  define PRIu8  PRIu32
#  define PRIx8  PRIx32
#  define PRIX8  PRIX32
#endif /* !defined(PRIU32) */
#if !defined(PRIu64)
#  if (SIZEOF_LONG >= 8)
#    define PRId64 "l" PRId32
#    define PRIi64 "l" PRIi32
#    define PRIo64 "l" PRIo32
#    define PRIu64 "l" PRIu32
#    define PRIx64 "l" PRIx32
#    define PRIX64 "l" PRIX32
#  else
#    define PRId64 "ll" PRId32
#    define PRIi64 "ll" PRIi32
#    define PRIo64 "ll" PRIo32
#    define PRIu64 "ll" PRIu32
#    define PRIx64 "ll" PRIx32
#    define PRIX64 "ll" PRIX32
#  endif
#endif /* !defined(PRIu64) */

/** this UNUSED macro is also stolen from silk_config.h */
#ifdef __GNUC__
#define UNUSED(var) /*@unused@*/ var __attribute__((__unused__))
#else
#define UNUSED(var) /*@unused@*/ var
#endif


#endif

