/*
 ** ring.c
 ** General ring array implementation
 **
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2007 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Brian Trammell <bht@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU General Public License (GPL) Rights pursuant to Version 2, June 1991
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 */

/* idem hack */
#ifndef _YAF_RING_H_
#define _YAF_RING_H_
#include <yaf/autoinc.h>

struct rgaRing_st;
typedef struct rgaRing_st rgaRing_t;

rgaRing_t *rgaAlloc(
    size_t          elt_sz,
    size_t          cap);

void rgaFree(
    rgaRing_t       *ring);

uint8_t *rgaNextHead(
    rgaRing_t       *ring);

void rgaRewindHead(
    rgaRing_t       *ring);

uint8_t *rgaNextTail(
    rgaRing_t       *ring);

size_t rgaCount(
    rgaRing_t       *ring);

size_t rgaPeak(
    rgaRing_t       *ring);

#if YAF_RING_THREAD

rgaRing_t *rgaAllocThreaded(
    size_t          elt_sz,
    size_t          cap);

uint8_t *rgaWaitHead(
    rgaRing_t       *ring);

void rgaReleaseHead(
    rgaRing_t       *ring,
    size_t          rsv);

uint8_t *rgaWaitTail(
    rgaRing_t       *ring);

void rgaReleaseTail(
    rgaRing_t       *ring,
    size_t          rsv);

void rgaSetInterrupt(
    rgaRing_t       *ring);

void rgaClearInterrupt(
    rgaRing_t       *ring);

#endif

/* end idem */
#endif
