/**
 * @internal
 *
 * @file playloadScanner.h
 *
 * This defines the interface to the payload scanner functions
 *
 *
 * @author $Author: inacio_svn $
 * @date $Date: 2008-08-21 17:07:05 -0400 (Thu, 21 Aug 2008) $
 * @version $Revision: 12303 $
 *
 *
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2007-2008 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Chris Inacio <inacio@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU General Public License (GPL) Rights pursuant to Version 2, June 1991
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 *
 */



#ifndef PAYLOAD_SCANNER_H_
#define PAYLOAD_SCANNER_H_



#define _YAF_SOURCE_
#include <yaf/autoinc.h>
#include <yaf/yafcore.h>
#include <yaf/decode.h>

/* if this is a power of 2, then the hash used for the sparse array is (every so slightly) more efficient */
#define MAX_PAYLOAD_RULES 1024


/**
 * ycInitializeScanRules
 *
 * @param scriptFile
 * @param err
 *
 *
 * @return FALSE if an error occurs, TRUE if there were no errors
 *
 */
gboolean            ycInitializeScanRules (
    FILE * scriptFile,
    GError ** err);
    
    
/**
 * ycScanPayload
 *
 *
 * @param payloadData
 * @param payloadSize
 * @param flow
 * @param val
 *
 * @return the value of the label of the matching rule if there is a match, otherwise 0
 *
 */
uint16_t
ycScanPayload (
    const uint8_t * payloadData,
    unsigned int payloadSize,
    yfFlow_t * flow,
    yfFlowVal_t * val);


#endif
