/**
 * @internal
 *
 * null plugin
 *
 * these plugins do nothing, they don't recognize any protocols, they 
 * are useful for testing the shared library loading and argument
 * passing to the plugins
 *
 * @author $Author: inacio_svn $
 * @date  $Date: 2008-01-08 15:31:44 -0500 (Tue, 08 Jan 2008) $
 * @version $Revision: 10048 $
 *
 *
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2007-2008 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Chris Inacio <inacio@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU General Public License (GPL) Rights pursuant to Version 2, June 1991
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 *
 */
#define _YAF_SOURCE_
#include <yaf/autoinc.h>
#include <yaf/yafcore.h>
#include <yaf/decode.h>


/* #define DEBUG_VERBOSITY */


/**
 * nullplugin_LTX_ycNullScanScan
 *
 * @param argc number of string arguments in argv
 * @param argv string arguments for this plugin (first two are library 
 *             name and function name)
 * @param payload the packet payload
 * @param payloadSize size of the packet payload
 * @param flow a pointer to the flow state structure
 * @param val a pointer to biflow state (used for forward vs reverse)
 *
 * @return always 0
 */
uint16_t
nullplugin_LTX_ycNullScanScan (
    int argc,
    char *argv[],
    uint8_t * payload,
    unsigned int payloadSize,
    yfFlow_t * flow,
    yfFlowVal_t * val)
{
#ifdef DEBUG_VERBOSITY
    int                 loop;
#endif

    /* supress compiler warnings about unused arguments */
    (void) payload;
    (void) payloadSize;
    (void) argc;
    (void) argv;
    (void) flow;
    (void) val;

#ifdef DEBUG_VERBOSITY
    for (loop = 0; loop < argc; loop++) {
        printf ("arg %d is \"%s\"\n", loop, argv[loop]);
    }
#endif

    return 0;
}

/**
 * nullplugin_LTX_ycNullScanScan2
 *
 * @param argc number of string arguments in argv
 * @param argv string arguments for this plugin (first two are library 
 *             name and function name)
 * @param payload the packet payload
 * @param payloadSize size of the packet payload
 * @param flow a pointer to the flow state structure
 * @param val a pointer to biflow state (used for forward vs reverse)
 *
 * @return always 0
 */
uint16_t
nullplugin_LTX_ycNullScanScan2 (
    int argc,
    char *argv[],
    uint8_t * payload,
    unsigned int payloadSize,
    yfFlow_t * flow,
    yfFlowVal_t * val)
{
#ifdef DEBUG_VERBOSITY
    int                 loop;
#endif

    /* supress compiler warnings about unused arguments */
    (void) payload;
    (void) payloadSize;
    (void) argc;
    (void) argv;
    (void) flow;
    (void) val;

#ifdef DEBUG_VERBOSITY
    for (loop = 0; loop < argc; loop++) {
        printf ("arg %d is \"%s\"\n", loop, argv[loop]);
    }
#endif

    return 0;
}

/**
 * nullplugin_LTX_ycNullScanScan3
 *
 * @param argc number of string arguments in argv
 * @param argv string arguments for this plugin (first two are library 
 *             name and function name)
 * @param payload the packet payload
 * @param payloadSize size of the packet payload
 * @param flow a pointer to the flow state structure
 * @param val a pointer to biflow state (used for forward vs reverse)
 *
 * @return always 0
 */
uint16_t
nullplugin_LTX_ycNullScanScan3 (
    int argc,
    char *argv[],
    uint8_t * payload,
    unsigned int payloadSize,
    yfFlow_t * flow,
    yfFlowVal_t * val)
{
#ifdef DEBUG_VERBOSITY
    int                 loop;
#endif

    /* supress compiler warnings about unused arguments */
    (void) payload;
    (void) payloadSize;
    (void) argc;
    (void) argv;
    (void) flow;
    (void) val;

#ifdef DEBUG_VERBOSITY
    for (loop = 0; loop < argc; loop++) {
        printf ("arg %d is \"%s\"\n", loop, argv[loop]);
    }
#endif

    return 0;
}

/**
 * nullplugin_LTX_ycNullScanScan4
 *
 * @param argc number of string arguments in argv
 * @param argv string arguments for this plugin (first two are library 
 *             name and function name)
 * @param payload the packet payload
 * @param payloadSize size of the packet payload
 * @param flow a pointer to the flow state structure
 * @param val a pointer to biflow state (used for forward vs reverse)
 *
 * @return always 0
 */
uint16_t
nullplugin_LTX_ycNullScanScan4 (
    int argc,
    char *argv[],
    uint8_t * payload,
    unsigned int payloadSize,
    yfFlow_t * flow,
    yfFlowVal_t * val)
{
#ifdef DEBUG_VERBOSITY
    int                 loop;
#endif

    /* supress compiler warnings about unused arguments */
    (void) payload;
    (void) payloadSize;
    (void) argc;
    (void) argv;
    (void) flow;
    (void) val;
    

#ifdef DEBUG_VERBOSITY
    for (loop = 0; loop < argc; loop++) {
        printf ("arg %d is \"%s\"\n", loop, argv[loop]);
    }
#endif

    return 0;
}
