/*
 ** picq.c
 ** General pickable queue implementation
 **
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2006-2007 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Brian Trammell <bht@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU General Public License (GPL) Rights pursuant to Version 2, June 1991
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 */

#define _YAF_SOURCE_
#include <yaf/picq.h>

typedef struct _PicQNode {
    struct _PicQNode    *p;
    struct _PicQNode    *n;
} PicQNode;

typedef struct _PicQ {
    PicQNode            *tail;
    PicQNode            *head;
} PicQ;

void piqPick (
    void        *vq,
    void        *vn)
{
    PicQ        *queue = (PicQ *)vq;
    PicQNode    *node = (PicQNode *)vn;
    
    /* only allow picking a double-null node if it's both head and tail. */
    if (!node->n && !node->p && 
        !(node == queue->head && node == queue->tail)) 
    {
        return;
    }
    
    /* connect previous to next */
    if (node->p) {
        node->p->n = node->n;
    } else {
        queue->tail = node->n;
    }
    
    /* connect next to previous */
    if (node->n) {
        node->n->p = node->p;
    } else {
        queue->head = node->p;
    }
    
    /* mark node picked */
    node->n = NULL;
    node->p = NULL;
}

void piqEnQ(
    void        *vq,
    void        *vn)
{
    PicQ        *queue = (PicQ *)vq;
    PicQNode    *node = (PicQNode *)vn;

    g_assert(!node->n && !node->p);

    if (queue->head) {
        queue->head->n = node;
    } else {
        queue->tail = node;
    }
    
    node->p = queue->head;
    queue->head = node;
}

void piqUnshift(
    void        *vq,
    void        *vn)
{
    PicQ        *queue = (PicQ *)vq;
    PicQNode    *node = (PicQNode *)vn;

    g_assert(!node->n && !node->p);

    if (queue->tail) {
        queue->tail->p = node;
    } else {
        queue->head = node;
    }
    
    node->n = queue->tail;
    queue->tail = node;
}

void *piqShift(
    void        *vq) 
{
    PicQ        *queue = (PicQ *)vq;
    PicQNode    *node = NULL;
    
    if (queue->head) {
        node = queue->head;
        piqPick(queue, node);
    }
    return node;
}

void *piqDeQ(
    void        *vq) 
{
    PicQ        *queue = (PicQ *)vq;
    PicQNode    *node = NULL;
    
    if (queue->tail) {
        node = queue->tail;
        piqPick(queue, node);
    }
    return node;
}
        
        
