/** @internal
 *
 * @file yafapplabel.c
 *
 * This file implements the application labeler interface for YAF.  It 
 * allows a limited set of information about a _flow_ to captured.  It 
 * processes very packet that comes through the pipe in order to pull 
 * out its information and record flow type and details.
 *
 * It must be enabled with a configure option to be included in YAF.
 *
 *
 * @author $Author: inacio_svn $
 * @date $Date: 2008-08-21 17:07:05 -0400 (Thu, 21 Aug 2008) $
 * @version $Revision: 12303 $
 *
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2007-2008 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Chris Inacio <inacio@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU General Public License (GPL) Rights pursuant to Version 2, June 1991
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 *
 */


#define _YAF_SOURCE_
#include <yaf/autoinc.h>

#if YAF_ENABLE_APPLABEL

#include <yaf/yafcore.h>
#include <yaf/decode.h>

#include "applabel/payloadScanner.h"

gboolean yfAppLabelInit(
    const char      *ruleFileName, 
    GError          **err) 
{
    FILE            *ruleFile = NULL;
    
    if (NULL == ruleFileName) {
        ruleFileName = YAF_CONF_DIR"/yafApplabelRules.conf";
    }
    
    ruleFile = fopen (ruleFileName, "r");
    if (NULL == ruleFile) {
        *err = g_error_new(YAF_ERROR_DOMAIN, YAF_ERROR_IO, "could not open "
            "application labeler rule file \"%s\" for reading", ruleFileName);
        return FALSE;
    }
    
    if (!ycInitializeScanRules(ruleFile, err)) {
        return FALSE;
    }
    
    return TRUE;
}

void yfAppLabelFlow(
    yfFlow_t *flow)
{
    if (!flow->appLabel && flow->val.paylen) {
        flow->appLabel = 
            ycScanPayload(flow->val.payload, flow->val.paylen, 
                          flow, &(flow->val));
    }
    
    if (!flow->appLabel && flow->rval.paylen) {
        flow->appLabel =
            ycScanPayload(flow->rval.payload, flow->rval.paylen, 
                          flow, &(flow->rval));
    }
}

#   endif

