/**
 *@internal
 *
 *@file yafapplabel.h
 *
 * This defines the interface to the YAF application labeler.
 *
 * @author $Author$
 * @date $Date$
 * @version $Revision$
 *
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2007-2008 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Chris Inacio <inacio@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU General Public License (GPL) Rights pursuant to Version 2, June 1991
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 *
 *
 */
 
#ifndef YAF_APP_LABEL_H_
#define YAF_APP_LABEL_H_

#define _YAF_SOURCE_
#include <yaf/autoinc.h>

#if YAF_ENABLE_APPLABEL

#include <yaf/yafcore.h>
#include <yaf/decode.h>

#include "applabel/payloadScanner.h"

/**
 * Initializes the application labeler engine from a specified rules file.
 *
 * @param ruleFileName the name of the file to use for the rules
 *        of the app labeler engine.
 * @param err an error descriptor.
 *
 * @return TRUE on success, FALSE otherwise
 */

gboolean yfAppLabelInit(
    const char      *ruleFileName, 
    GError          **err);

/**
 * Labels a flow's protocol according to its payload. Sets the appLabel
 * field within the flow.
 *
 * @param flow A YAF flow.
 *
 */

void yfAppLabelFlow(
    yfFlow_t        *flow);

#endif /* YAF_ENABLE_APPLABEL */

#endif



