/*
 ** yafcap.h
 ** YAF libpcap input support
 **
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2006-2007 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Brian Trammell <bht@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU General Public License (GPL) Rights pursuant to Version 2, June 1991
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 */

#ifndef _YAF_CAP_H_
#define _YAF_CAP_H_

#include <yaf/autoinc.h>
#include "yafctx.h"

struct yfCapSource_st;
typedef struct yfCapSource_st yfCapSource_t;

yfCapSource_t *yfCapOpenFile(
    const char              *path,
    int                     *datalink,
    GError                  **err);

yfCapSource_t *yfCapOpenFileList(
    const char              *path,
    int                     *datalink,
    GError                  **err);

yfCapSource_t *yfCapOpenLive(
    const char              *ifname,
	int						snaplen,
    int                     *datalink,
    GError                  **err);

void yfCapClose(
    yfCapSource_t           *pcap);

void *yfCapMain(
    yfContext_t             *ctx);

void yfCapDumpStats();

#endif
