/*
 ** yafdag.h
 ** YAF Endace DAG live input support
 **
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2006-2007 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Brian Trammell <bht@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU General Public License (GPL) Rights pursuant to Version 2, June 1991
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 */

#ifndef _YAF_DAG_H_
#define _YAF_DAG_H_

struct yfDagSource_st;
typedef struct yfDagSource_st yfDagSource_t;

yfDagSource_t *yfDagOpenLive(
    const char              *ifname,
	int						snaplen,
    int                     *datalink,
    GError                  **err);

void yfDagClose(
    yfDagSource_t            *ds);

void *yfDagMain(
    yfContext_t              *ctx);

void yfDagDumpStats();

#endif
