/*
 ** yafout.h
 ** YAF IPFIX file and session output support
 **
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2006-2007 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Brian Trammell <bht@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU General Public License (GPL) Rights pursuant to Version 2, June 1991
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 */

#ifndef _YAF_OUT_H_
#define _YAF_OUT_H_

#include <yaf/autoinc.h>
#include <airframe/airlock.h>
#include <fixbuf/public.h>
#include "yafctx.h"

fBuf_t *yfOutputOpen(
    yfConfig_t              *cfg,
    AirLock                 *lock,
    GError                  **err);

void yfOutputClose(
    fBuf_t                  *fbuf,
    AirLock                 *lock,
    gboolean                flush);
    
#endif
