/*
 ** yafstat.c
 ** YAF Statistics Signal Handler
 **
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2006-2007 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Brian Trammell <bht@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU General Public License (GPL) Rights pursuant to Version 2, June 1991
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 */
 
#define _YAF_SOURCE_
#include "yafstat.h"
#include <yaf/yaftab.h>
#include <yaf/yafrag.h>
#include <yaf/decode.h>

static uint32_t yaf_do_stat = 0;
static GTimer *yaf_fft = NULL;
static yfContext_t *statctx = NULL;

static void yfSigUsr1()
{
    ++yaf_do_stat;
}

void yfStatInit(
	yfContext_t		*ctx)
{
    struct sigaction sa, osa;

    /* install usr1 handler */
    sa.sa_handler = yfSigUsr1;
    sigemptyset(&sa.sa_mask);
    sa.sa_flags = SA_RESTART;
    if (sigaction(SIGUSR1,&sa,&osa)) {
        g_error("sigaction(SIGUSR1) failed: %s", strerror(errno));
    }

	/* stash statistics context */
	statctx = ctx;

    /* start the timer */
    yaf_fft = g_timer_new();
    g_timer_start(yaf_fft);
}

static void yfStatDump()
{
    yfFlowDumpStats(statctx->flowtab, yaf_fft);
    yfFragDumpStats(statctx->fragtab);
    yfDecodeDumpStats(statctx->dectx);
}

void yfStatDumpLoop()
{
    if (yaf_do_stat) {
        --yaf_do_stat;
        yfStatDump();
    }
}

void yfStatComplete() 
{
    g_timer_stop(yaf_fft);
    yfStatDump();
}
