#! /usr/bin/env perl

##  Copyright 2003-2023 Carnegie Mellon University
##  See license information in LICENSE.txt.

##  This script modifies the HTML man pages generated by pod2html.  It
##  performs minor clean up and creates links to other man pages.


use warnings;
use strict;
use File::Copy  qw//;
use File::Temp  qw//;

# name of this script
my $NAME = $0;
$NAME =~ s,.*/,,;

# Other man pages to link to
my @man_pages = qw(
    airdaemon
    applabel
    filedaemon
    getFlowKeyHash
    yaf
    yaf.init
    yafMeta2Pcap
    yafdhcp
    yafdpi
    yafscii
    yafzcbalance
    );
our $man_re = '('.join('|', map { "\Q$_\E" } @man_pages).')';

our $old = $ARGV[0];
unless ($old) {
    die "Usage: $NAME <filename>\n\tClean HTML in the specified file\n";
}

open(OLD, '<', $old)
    or die "$NAME: Cannot open '$old' for reading: $!\n";

our ($fh, $new) = File::Temp::tempfile(UNLINK => 1)
    or die "$NAME: Unable to create a temporary file: $!\n";
*NEW = $fh;

do_manpage();

close OLD;
close NEW
    or die "$NAME: Cannot close '$new': $!\n";

File::Copy::move $new, $old
    or die "$NAME: Cannot replace '$old' with '$new': $!\n";

exit;


sub do_manpage
{
    $/ = "";  # read one paragraph at a time
    while (<OLD>) {
        # # Downgrade all <Hn> tags by one
        # s{(</?h)(\d)\b([^>]*>)}{$1.($2 +1 ).$3}gieo;

        # Get rid of any mailto: links
        s{<link[^>]+mailto:[^>]+>}{}i;

        # Remove all <hr>
        s{<hr\b[^>]*>}{}iog;

        # # Change <a name> to <a id>
        # s{<a name="}{<a id="}iog;

        # Make links to other man pages
        s{(<b>$man_re\(\d\)</b>)}{<a href="$2.html">$1</a>}og;

        print NEW;
    }
}
# do_manpage


__END__
@DISTRIBUTION_STATEMENT_BEGIN@
YAF 2.15.0

Copyright 2023 Carnegie Mellon University.

NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF FITNESS FOR
PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS OBTAINED FROM USE OF
THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF
ANY KIND WITH RESPECT TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT
INFRINGEMENT.

Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or
contact permission@sei.cmu.edu for full terms.

[DISTRIBUTION STATEMENT A] This material has been approved for public
release and unlimited distribution.  Please see Copyright notice for
non-US Government use and distribution.

GOVERNMENT PURPOSE RIGHTS - Software and Software Documentation
Contract No.: FA8702-15-D-0002
Contractor Name: Carnegie Mellon University
Contractor Address: 4500 Fifth Avenue, Pittsburgh, PA 15213

The Government's rights to use, modify, reproduce, release, perform,
display, or disclose this software are restricted by paragraph (b)(2) of
the Rights in Noncommercial Computer Software and Noncommercial Computer
Software Documentation clause contained in the above identified
contract. No restrictions apply after the expiration date shown
above. Any reproduction of the software or portions thereof marked with
this legend must also reproduce the markings.

This Software includes and/or makes use of Third-Party Software each
subject to its own license.

DM23-2313
@DISTRIBUTION_STATEMENT_END@
