##  @DISTRIBUTION_STATEMENT_BEGIN@
##  YAF 2.15.0
##
##  Copyright 2023 Carnegie Mellon University.
##
##  NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
##  INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
##  UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
##  AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF FITNESS FOR
##  PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS OBTAINED FROM USE OF
##  THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF
##  ANY KIND WITH RESPECT TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT
##  INFRINGEMENT.
##
##  Licensed under a GNU GPL 2.0-style license, please see LICENSE.txt or
##  contact permission@sei.cmu.edu for full terms.
##
##  [DISTRIBUTION STATEMENT A] This material has been approved for public
##  release and unlimited distribution.  Please see Copyright notice for
##  non-US Government use and distribution.
##
##  GOVERNMENT PURPOSE RIGHTS - Software and Software Documentation
##  Contract No.: FA8702-15-D-0002
##  Contractor Name: Carnegie Mellon University
##  Contractor Address: 4500 Fifth Avenue, Pittsburgh, PA 15213
##
##  The Government's rights to use, modify, reproduce, release, perform,
##  display, or disclose this software are restricted by paragraph (b)(2) of
##  the Rights in Noncommercial Computer Software and Noncommercial Computer
##  Software Documentation clause contained in the above identified
##  contract. No restrictions apply after the expiration date shown
##  above. Any reproduction of the software or portions thereof marked with
##  this legend must also reproduce the markings.
##
##  This Software includes and/or makes use of Third-Party Software each
##  subject to its own license.
##
##  DM23-2313
##  @DISTRIBUTION_STATEMENT_END@

%define name yaf
%define version 2.15.0
%define release 1

Summary: Yet Another Flow sensor
Name: %{name}
Version: %{version}
Release: %{release}%{?dist}
Group: Applications/System
License: GPLv2
Source: http://tools.netsa.cert.org/releases/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}
Vendor: http://tools.netsa.cert.org/
URL: http://tools.netsa.cert.org/yaf/
Requires(post): /sbin/ldconfig, /sbin/chkconfig
Requires(preun): /sbin/chkconfig
Requires(postun): /sbin/ldconfig


%description
YAF is Yet Another Flow sensor. It processes packet data from pcap(3) dumpfiles
as generated by tcpdump(1) or via live capture from an interface using pcap(3)
or an Endace DAG card into bidirectional flows, then exports those flows to
IPFIX Collecting Processes or in an IPFIX-based file format. YAF's output can
be used with the SiLK tools, yafscii, and super_mediator.

%package devel
Summary: Static libraries and C header files for yaf
Group: Development/Libraries
Requires: %{name} = %{version}
Requires: pkgconfig >= 0.8

%description devel
Static libraries and C header files for yaf.

%prep
%setup -q -n %{name}-%{version}

%build
%configure  --enable-plugins --enable-applabel
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
%{__make}

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_bindir}
%makeinstall

mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/init.d/
install --mode=0755 etc/init.d/yaf $RPM_BUILD_ROOT%{_sysconfdir}/init.d/
install --mode=0644 etc/yaf.conf $RPM_BUILD_ROOT%{_sysconfdir}

%post                                                                           
/sbin/ldconfig
function runlvl(){
    ( /sbin/chkconfig --del $1 || true )
    /sbin/chkconfig --add $1
    /sbin/chkconfig --levels 345 $1 on
    /sbin/chkconfig --levels 016 $1 off
}

%postun -p /sbin/ldconfig

%preun
if [ "$1" = 0 ]; then
    /sbin/chkconfig --del yaf
fi

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
%doc AUTHORS LICENSE.txt NEWS README doc/html
%{_bindir}/yaf
%{_bindir}/yafscii
%{_bindir}/yafcollect
%{_bindir}/airdaemon
%{_bindir}/filedaemon
%{_bindir}/getFlowKeyHash
%{_bindir}/yafMeta2Pcap
%{_libdir}/*.so.*
%if "x1" == "x1"
%{_libdir}/yaf/*.so*
%{_libdir}/yaf/*.la 
%endif
%{_mandir}/man*/*
%dir %{_datadir}/yaf
%{_datadir}/yaf/yaf.init
%config(noreplace) %{_sysconfdir}/yafApplabelRules.conf
%if "x1" == "x1"
%config(noreplace) %{_sysconfdir}/yafDPIRules.conf
%config(noreplace) %{_sysconfdir}/dhcp_fingerprints.conf
%endif
%if "x@YAF_REQ_P0F_CONF@" == "x1"
%config(noreplace) %{_sysconfdir}/p0f.fp
%endif
%config(noreplace) %{_sysconfdir}/yaf.conf
%attr(755,root,root) %{_sysconfdir}/init.d/yaf 

%files devel
%defattr(-, root, root)
%{_includedir}/*
%{_libdir}/*.la
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%changelog
